/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.rest.service.api.runtime.process.SignalEventReceivedRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Runtime"}, description="Manage Runtime", authorizations={@Authorization(value="basicAuth")})
public class SignalResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;

    @ApiOperation(value="Signal event received", tags={"Runtime"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicated signal has been processed and no errors occurred."), @ApiResponse(code=202, message="Indicated signal processing is queued as a job, ready to be executed."), @ApiResponse(code=400, message="Signal not processed. The signal name is missing or variables are used together with async, which is not allowed. Response body contains additional information about the error.")})
    @PostMapping(value={"/runtime/signals"})
    public void signalEventReceived(@RequestBody SignalEventReceivedRequest signalRequest, HttpServletResponse response) {
        if (signalRequest.getSignalName() == null) {
            throw new FlowableIllegalArgumentException("signalName is required");
        }
        HashMap<String, Object> signalVariables = null;
        if (signalRequest.getVariables() != null) {
            signalVariables = new HashMap<String, Object>();
            for (RestVariable variable : signalRequest.getVariables()) {
                if (variable.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required.");
                }
                signalVariables.put(variable.getName(), this.restResponseFactory.getVariableValue(variable));
            }
        }
        if (signalRequest.isAsync()) {
            if (signalVariables != null) {
                throw new FlowableIllegalArgumentException("Async signals cannot take variables as payload");
            }
            if (signalRequest.isCustomTenantSet()) {
                this.runtimeService.signalEventReceivedAsyncWithTenantId(signalRequest.getSignalName(), signalRequest.getTenantId());
            } else {
                this.runtimeService.signalEventReceivedAsync(signalRequest.getSignalName());
            }
            response.setStatus(HttpStatus.ACCEPTED.value());
        } else {
            if (signalRequest.isCustomTenantSet()) {
                this.runtimeService.signalEventReceivedWithTenantId(signalRequest.getSignalName(), signalVariables, signalRequest.getTenantId());
            } else {
                this.runtimeService.signalEventReceived(signalRequest.getSignalName(), signalVariables);
            }
            response.setStatus(HttpStatus.NO_CONTENT.value());
        }
    }
}

