/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.rest.api.DataResponse;
import org.flowable.rest.service.api.runtime.process.ExecutionBaseResource;
import org.flowable.rest.service.api.runtime.process.ExecutionQueryRequest;
import org.flowable.rest.service.api.runtime.process.ExecutionResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Executions"}, description="Manage Executions", authorizations={@Authorization(value="basicAuth")})
public class ExecutionQueryResource
extends ExecutionBaseResource {
    @ApiOperation(value="Query executions", tags={"Executions", "Query"}, nickname="queryExecutions", notes="The request body can contain all possible filters that can be used in the List executions URL query. On top of these, it\u2019s possible to provide an array of variables and processInstanceVariables to include in the query, with their format described here.\n\nThe general paging and sorting query-parameters can be used for this URL.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the executions are returned."), @ApiResponse(code=404, message="Indicates a parameter was passed in the wrong format . The status-message contains additional information.")})
    @PostMapping(value={"/query/executions"}, produces={"application/json"})
    public DataResponse<ExecutionResponse> queryProcessInstances(@RequestBody ExecutionQueryRequest queryRequest, @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        return this.getQueryResponse(queryRequest, allRequestParams, request.getRequestURL().toString().replace("/query/executions", ""));
    }
}

