/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.BaseModelerRestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractModelBpmnResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractModelBpmnResource.class);
    @Autowired
    protected ModelService modelService;

    public void getProcessModelBpmn20Xml(HttpServletResponse response, String processModelId) throws IOException {
        if (processModelId == null) {
            throw new BadRequestException("No process model id provided");
        }
        Model model = this.modelService.getModel(processModelId);
        this.generateBpmn20Xml(response, (AbstractModel)model);
    }

    public void getHistoricProcessModelBpmn20Xml(HttpServletResponse response, String processModelId, String processModelHistoryId) throws IOException {
        if (processModelId == null) {
            throw new BadRequestException("No process model id provided");
        }
        ModelHistory historicModel = this.modelService.getModelHistory(processModelId, processModelHistoryId);
        this.generateBpmn20Xml(response, (AbstractModel)historicModel);
    }

    protected void generateBpmn20Xml(HttpServletResponse response, AbstractModel model) {
        String name = model.getName().replaceAll(" ", "_") + ".bpmn20.xml";
        String encodedName = null;
        try {
            encodedName = "UTF-8''" + URLEncoder.encode(name, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to encode name " + name);
        }
        String contentDispositionValue = "attachment; filename=" + name;
        if (encodedName != null) {
            contentDispositionValue = contentDispositionValue + "; filename*=" + encodedName;
        }
        response.setHeader("Content-Disposition", contentDispositionValue);
        if (model.getModelEditorJson() != null) {
            try {
                int count;
                ServletOutputStream servletOutputStream = response.getOutputStream();
                response.setContentType("application/xml");
                BpmnModel bpmnModel = this.modelService.getBpmnModel(model);
                byte[] xmlBytes = this.modelService.getBpmnXML(bpmnModel);
                BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(xmlBytes));
                byte[] buffer = new byte[8096];
                while ((count = in.read(buffer)) != -1) {
                    servletOutputStream.write(buffer, 0, count);
                }
                servletOutputStream.flush();
                servletOutputStream.close();
            }
            catch (BaseModelerRestException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Could not generate BPMN 2.0 XML", (Throwable)e);
                throw new InternalServerErrorException("Could not generate BPMN 2.0 xml");
            }
        }
    }
}

