/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.service.BpmnDisplayJsonConverter;
import org.flowable.ui.modeler.service.CmmnDisplayJsonConverter;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class EditorDisplayJsonClientResource {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected BpmnDisplayJsonConverter bpmnDisplayJsonConverter;
    @Autowired
    protected CmmnDisplayJsonConverter cmmnDisplayJsonConverter;
    protected ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping(value={"/rest/models/{modelId}/model-json"}, produces={"application/json"})
    public JsonNode getModelJSON(@PathVariable String modelId) {
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        Model model = this.modelService.getModel(modelId);
        if (model.getModelType() != null && 5 == model.getModelType()) {
            this.cmmnDisplayJsonConverter.processCaseElements((AbstractModel)model, displayNode, new org.flowable.cmmn.model.GraphicInfo());
        } else {
            this.bpmnDisplayJsonConverter.processProcessElements((AbstractModel)model, displayNode, new GraphicInfo());
        }
        return displayNode;
    }

    @GetMapping(value={"/rest/models/{processModelId}/history/{processModelHistoryId}/model-json"}, produces={"application/json"})
    public JsonNode getModelHistoryJSON(@PathVariable String processModelId, @PathVariable String processModelHistoryId) {
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        ModelHistory model = this.modelService.getModelHistory(processModelId, processModelHistoryId);
        if (model.getModelType() != null && 5 == model.getModelType()) {
            this.cmmnDisplayJsonConverter.processCaseElements((AbstractModel)model, displayNode, new org.flowable.cmmn.model.GraphicInfo());
        } else {
            this.bpmnDisplayJsonConverter.processProcessElements((AbstractModel)model, displayNode, new GraphicInfo());
        }
        return displayNode;
    }
}

