/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester;

import org.apache.commons.lang3.Validate;
import org.force66.beantester.BeanTesterConfiguration;
import org.force66.beantester.DefaultBeanTesterConfiguration;
import org.force66.beantester.tests.BeanTest;
import org.force66.beantester.utils.BeanTesterException;
import org.force66.beantester.valuegens.GenericValueGenerator;

public class BeanTester {
    private BeanTesterConfiguration configuration = null;

    public BeanTester() {
        this(new DefaultBeanTesterConfiguration());
    }

    public BeanTester(BeanTesterConfiguration config) {
        Validate.notNull((Object)config, (String)"Null BeanTesterConfiguration not allowed.", (Object[])new Object[0]);
        this.configuration = config;
    }

    public void addExcludedField(String fieldName) {
        Validate.notEmpty((CharSequence)fieldName, (String)"Null or blank fieldName not allowed.", (Object[])new Object[0]);
        this.configuration.getFieldExclusionSet().add(fieldName);
    }

    public void addTestValues(Class<?> fieldClass, Object[] values) {
        Validate.notNull(fieldClass, (String)"Null fieldClass not allowed.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])values, (String)"Null values array not allowed.", (Object[])new Object[0]);
        this.configuration.getValueGeneratorFactory().registerGenerator(fieldClass, new GenericValueGenerator(values));
    }

    public void testBean(Class<?> beanClass) {
        this.testBean(beanClass, null);
    }

    public void testBean(Class<?> beanClass, Object[] constructorArgs) {
        Validate.notNull(beanClass, (String)"Null beanClass not allowed.", (Object[])new Object[0]);
        for (BeanTest test : this.configuration.getBeanTestList()) {
            if (test.testBeanClass(beanClass, constructorArgs)) continue;
            throw new BeanTesterException("FailedTest").addContextValue("test", test.getClass().getName()).addContextValue("failure reason", (Object)test.getFailureReason());
        }
    }
}

