/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.tests;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.force66.beantester.tests.BaseBeanTest;
import org.force66.beantester.tests.ValuePropertyTest;
import org.force66.beantester.utils.BeanTesterException;
import org.force66.beantester.utils.InstantiationUtils;
import org.force66.beantester.valuegens.ValueGenerator;
import org.force66.beantester.valuegens.ValueGeneratorFactory;

public class AccessorMutatorTest
extends BaseBeanTest {
    private Set<String> fieldExclusionSet;
    private ValueGeneratorFactory valueGeneratorFactory;

    public AccessorMutatorTest(ValueGeneratorFactory factory, Set<String> fieldExclusions) {
        Validate.notNull(fieldExclusions, (String)"Null fieldExclusionSet not allowed.", (Object[])new Object[0]);
        Validate.notNull((Object)factory, (String)"Null ValueGeneratorFactory not allowed.", (Object[])new Object[0]);
        this.valueGeneratorFactory = factory;
        this.fieldExclusionSet = fieldExclusions;
    }

    @Override
    public boolean testBeanClass(Class<?> klass, Object[] constructorArgs) {
        this.setFailureReason(null);
        Object bean = InstantiationUtils.safeNewInstance(klass, constructorArgs);
        Object localBean = null;
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors((Object)bean)) {
            if (this.fieldExclusionSet.contains(descriptor.getName())) continue;
            localBean = InstantiationUtils.safeNewInstance(klass, constructorArgs);
            try {
                this.testProperty(localBean, descriptor);
            }
            catch (TestFailureException e) {
                this.setFailureReason(e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected void testProperty(Object bean, PropertyDescriptor descriptor) {
        try {
            this.performNullTest(bean, descriptor);
            for (Object value : this.generateValues(descriptor.getPropertyType())) {
                this.performValueTest(bean, descriptor, value);
            }
        }
        catch (TestFailureException are) {
            throw are;
        }
        catch (BeanTesterException are) {
            throw are.addContextValue("bean type", bean.getClass().getName()).addContextValue("field", (Object)descriptor.getName());
        }
        catch (Exception e) {
            throw new BeanTesterException(e).addContextValue("bean type", bean.getClass().getName()).addContextValue("field", (Object)descriptor.getName());
        }
    }

    protected void performValueTest(Object bean, PropertyDescriptor descriptor, Object value) throws IllegalAccessException, InvocationTargetException {
        if (!new ValuePropertyTest().testProperty(bean, descriptor, value)) {
            throw new TestFailureException("Property test failed a value test; we set the property to a test value and expected the property value to be equal afterward").addContextValue("fieldName", descriptor.getName()).addContextValue("class", (Object)bean.getClass().getName()).addContextValue("test value", value);
        }
    }

    protected void performNullTest(Object bean, PropertyDescriptor descriptor) throws IllegalAccessException, InvocationTargetException {
        if (!new ValuePropertyTest().testProperty(bean, descriptor, null)) {
            throw new TestFailureException("Property test failed null test; we set the property to null and expected the property value to be null afterward").addContextValue("fieldName", descriptor.getName()).addContextValue("class", (Object)bean.getClass().getName()).addContextValue("test value", null);
        }
    }

    protected Object[] generateValues(Class<?> type) {
        ValueGenerator<?> generator = this.valueGeneratorFactory.forClass(type);
        if (generator != null) {
            return generator.makeValues();
        }
        return new Object[0];
    }

    static class TestFailureException
    extends ContextedRuntimeException {
        public TestFailureException(String message) {
            super(message);
        }
    }
}

