/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.tests;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.force66.beantester.tests.BeanPropertyTest;
import org.force66.beantester.utils.BeanTesterException;

public class ValuePropertyTest
implements BeanPropertyTest {
    @Override
    public boolean testProperty(Object bean, PropertyDescriptor descriptor, Object value) {
        Validate.notNull((Object)bean, (String)"Null bean not allowed", (Object[])new Object[0]);
        Validate.notNull((Object)descriptor, (String)"Null PropertyDescriptor not allowed", (Object[])new Object[0]);
        boolean answer = true;
        if (descriptor.getPropertyType().isPrimitive() && value == null) {
            return answer;
        }
        boolean fieldExists = FieldUtils.getField(bean.getClass(), (String)descriptor.getName(), (boolean)true) != null;
        try {
            if (descriptor.getWriteMethod() != null) {
                descriptor.getWriteMethod().invoke(bean, value);
                answer = this.testReadValue(bean, descriptor, value);
            } else if (fieldExists) {
                FieldUtils.writeField((Object)bean, (String)descriptor.getName(), (Object)value, (boolean)true);
                answer = this.testReadValue(bean, descriptor, value);
            }
            if (descriptor.getReadMethod() != null) {
                descriptor.getReadMethod().invoke(bean, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new BeanTesterException("Failed executing assignment test for accessor/mutator", e).addContextValue("property", descriptor).addContextValue("value class", value == null ? null : value.getClass().getName()).addContextValue("value", value);
        }
        return answer;
    }

    private boolean testReadValue(Object bean, PropertyDescriptor descriptor, Object value) throws IllegalAccessException, InvocationTargetException {
        boolean answer = true;
        if (descriptor.getReadMethod() != null) {
            answer = value == null ? descriptor.getReadMethod().invoke(bean, new Object[0]) == null : value.equals(descriptor.getReadMethod().invoke(bean, new Object[0]));
        }
        return answer;
    }
}

