/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.force66.beantester.utils.BeanTesterException;

public class GenericProxyHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -364189548578793927L;
    private Class<?> interfaceType;

    public GenericProxyHandler() {
    }

    public GenericProxyHandler(Class<?> interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName())) {
            Object other = args[0];
            if (other == null) {
                return false;
            }
            if (other instanceof Proxy) {
                GenericProxyHandler otherProxyHandler = (GenericProxyHandler)Proxy.getInvocationHandler(other);
                return this.interfaceType.equals(otherProxyHandler.interfaceType);
            }
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        throw new BeanTesterException("This is a generic interface proxy with no functionality").addContextValue("method", method.getName()).addContextValue("interface class", (Object)this.interfaceType.getName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.interfaceType);
        out.close();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.interfaceType = (Class)in.readObject();
        in.close();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.interfaceType = null;
    }
}

