/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.utils;

import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.force66.beantester.utils.BeanTesterException;
import org.force66.beantester.valuegens.ValueGenerator;
import org.force66.beantester.valuegens.ValueGeneratorFactory;

public class InjectionUtils {
    public static void injectValues(Object bean, ValueGeneratorFactory valueGeneratorFactory, boolean reportExceptions) {
        ?[] generatedValues = null;
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors((Object)bean)) {
            try {
                ValueGenerator<?> generator = valueGeneratorFactory.forClass(descriptor.getPropertyType());
                if (generator == null || descriptor.getWriteMethod() == null) continue;
                generatedValues = generator.makeValues();
                descriptor.getWriteMethod().invoke(bean, generatedValues[0]);
            }
            catch (Exception e) {
                if (!reportExceptions) continue;
                throw new BeanTesterException("Error setting property value", e).addContextValue("class", bean.getClass().getName()).addContextValue("field", (Object)descriptor.getName()).addContextValue("value", generatedValues != null && generatedValues.length > 0 ? generatedValues[0] : null);
            }
        }
    }
}

