/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionVisitor;
import org.geolatte.geom.jts.DimensionalCoordinate;

abstract class AbstractPositionSequence<P extends Position>
implements PositionSequence<P>,
CoordinateSequence {
    private final PositionFactory<P> factory;

    public AbstractPositionSequence(PositionFactory<P> factory) {
        this.factory = factory;
    }

    private static Coordinate[] toCoordinateArray(AbstractPositionSequence cseq) {
        Coordinate[] coordinates = new Coordinate[cseq.size()];
        for (int i = 0; i < cseq.size(); ++i) {
            coordinates[i] = cseq.getCoordinate(i);
        }
        return coordinates;
    }

    @Override
    public Class<P> getPositionClass() {
        return this.factory.forClass();
    }

    @Override
    public PositionFactory<P> getPositionFactory() {
        return this.factory;
    }

    @Override
    public P getPositionN(int index) {
        double[] co = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, co);
        return this.factory.mkPosition(co);
    }

    public int getDimension() {
        return this.getCoordinateDimension();
    }

    @Override
    public int getCoordinateDimension() {
        return this.factory.getCoordinateDimension();
    }

    @Override
    public abstract PositionSequence<P> clone();

    public Coordinate getCoordinate(int i) {
        DimensionalCoordinate co = new DimensionalCoordinate();
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(i, c);
        int idx = 0;
        co.x = c[idx++];
        co.y = c[idx++];
        if (this.factory.hasZComponent()) {
            co.z = c[idx++];
        }
        if (this.factory.hasMComponent()) {
            co.m = c[idx];
        }
        return co;
    }

    public Coordinate getCoordinateCopy(int i) {
        return this.getCoordinate(i);
    }

    public void getCoordinate(int index, Coordinate coord) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        coord.x = c[0];
        coord.y = c[1];
    }

    public double getX(int index) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        return c[0];
    }

    public double getY(int index) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        return c[1];
    }

    public double getOrdinate(int i, int ordinateIndex) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(i, c);
        boolean idx = false;
        switch (ordinateIndex) {
            case 0: {
                return c[0];
            }
            case 1: {
                return c[1];
            }
            case 2: {
                return this.factory.hasZComponent() ? c[2] : Double.NaN;
            }
            case 3: {
                return this.factory.hasMComponent() ? c[this.factory.getMComponentIndex()] : Double.NaN;
            }
        }
        throw new IllegalArgumentException("Ordinate index " + ordinateIndex + " is not supported.");
    }

    public abstract void setOrdinate(int var1, int var2, double var3);

    public Coordinate[] toCoordinateArray() {
        return AbstractPositionSequence.toCoordinateArray(this);
    }

    public Envelope expandEnvelope(Envelope envelope) {
        EnvelopeExpander expander = new EnvelopeExpander(envelope);
        this.accept(expander);
        return expander.result();
    }

    @Override
    public abstract void accept(PositionVisitor<P> var1);

    private static class EnvelopeExpander<P extends Position>
    implements PositionVisitor<P> {
        private final Envelope env;
        final double[] buffer = new double[2];

        EnvelopeExpander(Envelope env) {
            this.env = env;
        }

        @Override
        public void visit(P position) {
            double[] ar = ((Position)position).toArray(this.buffer);
            this.env.expandToInclude(ar[0], ar[1]);
        }

        public Envelope result() {
            return this.env;
        }
    }
}

