/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import org.geolatte.geom.AbstractPositionSequenceBuilder;
import org.geolatte.geom.PackedPositionSequence;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.Positions;

class VariableSizePositionSequenceBuilder<P extends Position>
extends AbstractPositionSequenceBuilder<P> {
    private double[] coordinates;
    private int index = 0;

    VariableSizePositionSequenceBuilder(Class<P> clazz) {
        this(Positions.getFactoryFor(clazz));
    }

    VariableSizePositionSequenceBuilder(PositionFactory<P> descriptor) {
        super(descriptor);
        this.coordinates = new double[descriptor.getCoordinateDimension() * 10];
    }

    @Override
    protected void addCoordinate(double val) {
        this.ensureCapacity();
        this.coordinates[this.index++] = val;
    }

    private void ensureCapacity() {
        if (this.index < this.coordinates.length) {
            return;
        }
        int newCapacity = this.coordinates.length * 3 / 2 + 1;
        this.coordinates = Arrays.copyOf(this.coordinates, newCapacity);
    }

    @Override
    public PositionSequence<P> toPositionSequence() {
        return new PackedPositionSequence(this.factory, Arrays.copyOf(this.coordinates, this.index));
    }
}

