/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PointSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.POINT;
    }

    @Override
    protected Geometry<?> internalDecode(SDOGeometry nativeGeom) {
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem(nativeGeom);
        Double[] ordinates = nativeGeom.getOrdinates().getOrdinateArray();
        if (ordinates.length == 0) {
            ordinates = nativeGeom.getDimension() == 2 ? new Double[]{nativeGeom.getPoint().x, nativeGeom.getPoint().y} : new Double[]{nativeGeom.getPoint().x, nativeGeom.getPoint().y, nativeGeom.getPoint().z};
        }
        return new Point(this.convertOrdinateArray(ordinates, nativeGeom, crs), (CoordinateReferenceSystem<PositionSequence<?>>)crs);
    }
}

