/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.SystemPropertyConstants;
import org.glassfish.api.admin.*;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.ActionReport;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

import java.util.List;

/**
 * Create Resource Ref Command
 *
 * @author Jennifer Chou, Jagadish Ramu
 * 
 */
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE })
@org.glassfish.api.admin.ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="create-resource-ref")
@Scoped(PerLookup.class)
@I18n("create.resource.ref")
public class CreateResourceRef implements AdminCommand {
    
    final private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateResourceRef.class);
    
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    
    @Param(optional=true)
    private String target = SystemPropertyConstants.DAS_SERVER_NAME;

    @Param(name="reference_name", primary=true)
    private String refName;
    
    @Inject
    private Domain domain;
    
    @Inject
    private ServerEnvironment environment;

    @Inject
    private Habitat habitat;

    /**
     * Executes the command with the command parameters passed as Properties
     * where the keys are the parameter names and the values the parameter values
     *
     * @param context information
     */
    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();

        // check if the resource exists before creating a reference
        if (!isResourceExists(refName)) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.resourceDoesNotExist",
                    "Resource {0} does not exist", refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }

        try {

            Server server = ConfigBeansUtilities.getServerNamed(target);
            if (server != null) {
                if (server.isResourceRefExists(refName)) {
                    report.setMessage(localStrings.getLocalString("create.resource.ref.existsAlready",
                            "Resource ref {0} already exists", refName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                // create new ResourceRef as a child of Server
                server.createResourceRef(enabled.toString(), refName);
            } else {
                Cluster cluster = domain.getClusterNamed(target);
                if (cluster.isResourceRefExists(refName)) {
                    report.setMessage(localStrings.getLocalString("create.resource.ref.existsAlready",
                            "Resource ref {0} already exists", refName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                // create new ResourceRef as a child of Cluster
                cluster.createResourceRef(enabled.toString(), refName);

                // create new ResourceRef for all instances of Cluster
                Target tgt = habitat.getComponent(Target.class);
                List<Server> instances = tgt.getInstances(target);
                for (Server svr : instances) {
                    svr.createResourceRef(enabled.toString(), refName);
                }
            }
        } catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed",
                    "Resource ref {0} creation failed", refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
            return;
        } catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed",
                    "Resource ref {0} creation failed", refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setMessage(localStrings.getLocalString("create.resource.ref.success",
                "resource-ref {0} created successfully.", refName));
        report.setActionExitCode(ec);
    }

    private boolean isResourceExists(String jndiName) {
        //resource-ref is created only for a BindableResource
        return domain.getResources().getResourceByName(BindableResource.class, jndiName) != null;
    }
}
