/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class BindableResourcesHelper {
    @Inject
    private Domain domain;
    @Inject
    private ConfigBeansUtilities configBeanUtilities;
    @Inject
    private ResourceUtil resourceUtil;
    private static final String DOMAIN = "domain";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BindableResourcesHelper.class);

    public boolean resourceExists(String jndiName, String target) {
        boolean exists = false;
        if (target.equals(DOMAIN)) {
            exists = true;
        } else if (ConfigBeansUtilities.getServerNamed((String)target) != null) {
            Server server = ConfigBeansUtilities.getServerNamed((String)target);
            exists = server.isResourceRefExists(jndiName);
        } else if (this.domain.getClusterNamed(target) != null) {
            Cluster cluster = this.domain.getClusterNamed(target);
            exists = cluster.isResourceRefExists(jndiName);
        } else {
            for (Config config : this.domain.getConfigs().getConfig()) {
                if (!config.getName().equals(target)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public ResourceStatus validateBindableResourceForDuplicates(Resources resources, String jndiName, boolean validateResourceRef, String target, Class<? extends BindableResource> resourceTypeToValidate) {
        BindableResource duplicateResource = (BindableResource)resources.getResourceByName(BindableResource.class, jndiName);
        if (duplicateResource != null) {
            String msg = validateResourceRef && this.getResourceByClass(duplicateResource).equals(resourceTypeToValidate) ? (target.equals(DOMAIN) ? localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", new Object[]{this.getResourceTypeName(duplicateResource), jndiName}) : (this.resourceUtil.getTargetsReferringResourceRef(jndiName).contains(target) ? localStrings.getLocalString("duplicate.resource.found.in.target", "A {0} by name {1} already exists with resource reference in target {2}.", new Object[]{this.getResourceTypeName(duplicateResource), jndiName, target}) : localStrings.getLocalString("duplicate.resource.need.to.create.resource.ref", "A {0} named {1} already exists. If you are trying to create the existing resourceconfiguration in target {2}, please use 'create-resource-ref' command (or create resource-ref using admin console).", new Object[]{this.getResourceTypeName(duplicateResource), jndiName, target}))) : localStrings.getLocalString("duplicate.resource.found", "A {0} by name {1} already exists.", new Object[]{this.getResourceTypeName(duplicateResource), jndiName});
            return new ResourceStatus(1, msg, true);
        }
        return new ResourceStatus(0, "Validation Successful");
    }

    public Class getResourceByClass(BindableResource resource) {
        Class<BindableResource> type = BindableResource.class;
        if (resource instanceof JdbcResource) {
            type = JdbcResource.class;
        } else if (resource instanceof ConnectorResource) {
            type = ConnectorResource.class;
        } else if (resource instanceof ExternalJndiResource) {
            type = ExternalJndiResource.class;
        } else if (resource instanceof CustomResource) {
            type = CustomResource.class;
        } else if (resource instanceof AdminObjectResource) {
            type = AdminObjectResource.class;
        } else if (resource instanceof MailResource) {
            type = MailResource.class;
        }
        return type;
    }

    public String getResourceTypeName(BindableResource resource) {
        String type = "Resource";
        if (resource instanceof JdbcResource) {
            type = "JdbcResource";
        } else if (resource instanceof ConnectorResource) {
            type = "ConnectorResource";
        } else if (resource instanceof ExternalJndiResource) {
            type = "ExternalJndiResource";
        } else if (resource instanceof CustomResource) {
            type = "CustomResource";
        } else if (resource instanceof AdminObjectResource) {
            type = "AdminObjectResource";
        } else if (resource instanceof MailResource) {
            type = "MailResource";
        }
        return type;
    }
}

