/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;

@Provider
public abstract class DefaultTemplateProcessor<T>
implements TemplateProcessor<T> {
    private final Configuration configuration;
    private String basePath = "";

    protected DefaultTemplateProcessor(Configuration configuration) {
        this.configuration = configuration;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected String getTemplateName(String template) {
        return this.basePath + template;
    }

    protected List<String> getPossibleTemplateNames(String template) {
        ArrayList possibleTemplateNames = Lists.newArrayList();
        String templateName = this.getTemplateName(template);
        possibleTemplateNames.add(templateName);
        for (String extension : this.getExtensions()) {
            possibleTemplateNames.add(templateName + extension);
        }
        return possibleTemplateNames;
    }

    protected abstract List<String> getExtensions();

    private String removeTrailingSlash(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    protected void setBasePathFromProperty(String basePathPropertyName) {
        String path = (String)this.configuration.getProperties().get(basePathPropertyName);
        this.basePath = path == null ? "" : (path.charAt(0) == '/' ? this.removeTrailingSlash(path) : "/" + this.removeTrailingSlash(path));
    }
}

