/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class HttpUrlConnector
implements Connector {
    private final ConnectionFactory connectionFactory;

    public HttpUrlConnector() {
        this.connectionFactory = null;
    }

    public HttpUrlConnector(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    private static InputStream getInputStream(final HttpURLConnection uc) throws IOException {
        return new InputStream(){
            private final UnsafeValue<InputStream, IOException> in = Values.lazy(new UnsafeValue<InputStream, IOException>(){

                @Override
                public InputStream get() throws IOException {
                    if (uc.getResponseCode() < 300) {
                        return uc.getInputStream();
                    }
                    InputStream ein = uc.getErrorStream();
                    return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
                }
            });

            @Override
            public int read() throws IOException {
                return this.in.get().read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.in.get().read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.in.get().read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return this.in.get().skip(n);
            }

            @Override
            public int available() throws IOException {
                return this.in.get().available();
            }

            @Override
            public void close() throws IOException {
                this.in.get().close();
            }

            @Override
            public void mark(int readLimit) {
                try {
                    this.in.get().mark(readLimit);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to retrieve the underlying input stream.", e);
                }
            }

            @Override
            public void reset() throws IOException {
                this.in.get().reset();
            }

            @Override
            public boolean markSupported() {
                try {
                    return this.in.get().markSupported();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to retrieve the underlying input stream.", e);
                }
            }
        };
    }

    @Override
    public ClientResponse apply(ClientRequest request) {
        try {
            return this._apply(request);
        }
        catch (IOException ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(HttpUrlConnector.this._apply(request));
                }
                catch (IOException ex) {
                    callback.failure(new ProcessingException(ex));
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    @Override
    public void close() {
    }

    private ClientResponse _apply(final ClientRequest request) throws IOException {
        Object entity;
        Map<String, Object> configurationProperties = request.getConfiguration().getProperties();
        URL endpointUrl = request.getUri().toURL();
        final HttpURLConnection uc = this.connectionFactory == null ? (HttpURLConnection)endpointUrl.openConnection() : this.connectionFactory.getConnection(endpointUrl);
        uc.setDoInput(true);
        String httpMethod = request.getMethod();
        if (PropertiesHelper.getValue(configurationProperties, "jersey.config.client.httpUrlConnection.setMethodWorkaround", false).booleanValue()) {
            HttpUrlConnector.setRequestMethodViaJreBugWorkaround(uc, httpMethod);
        } else {
            uc.setRequestMethod(httpMethod);
        }
        uc.setInstanceFollowRedirects(PropertiesHelper.getValue(configurationProperties, "jersey.config.client.followRedirects", true));
        uc.setConnectTimeout(PropertiesHelper.getValue(configurationProperties, "jersey.config.client.connectTimeout", 0));
        uc.setReadTimeout(PropertiesHelper.getValue(configurationProperties, "jersey.config.client.readTimeout", 0));
        if (uc instanceof HttpsURLConnection) {
            HttpsURLConnection suc = (HttpsURLConnection)uc;
            JerseyClient client = request.getClient();
            HostnameVerifier verifier = client.getHostnameVerifier();
            if (verifier != null) {
                suc.setHostnameVerifier(verifier);
            }
            suc.setSSLSocketFactory(client.getSslContext().getSocketFactory());
        }
        if ((entity = request.getEntity()) != null) {
            Logger logger;
            uc.setDoOutput(true);
            if (httpMethod.equalsIgnoreCase("GET") && (logger = Logger.getLogger(HttpUrlConnector.class.getName())).isLoggable(Level.INFO)) {
                logger.log(Level.INFO, LocalizationMessages.HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
            }
            request.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                @Override
                public OutputStream getOutputStream(int contentLength) throws IOException {
                    HttpUrlConnector.this.writeOutBoundHeaders(request.getStringHeaders(), uc);
                    return uc.getOutputStream();
                }
            });
            request.writeEntity();
        } else {
            this.writeOutBoundHeaders(request.getStringHeaders(), uc);
        }
        ClientResponse responseContext = new ClientResponse(Statuses.from(uc.getResponseCode()), request);
        responseContext.headers(Maps.filterKeys(uc.getHeaderFields(), (Predicate)Predicates.notNull()));
        responseContext.setEntityStream(HttpUrlConnector.getInputStream(uc));
        return responseContext;
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, String> headers, HttpURLConnection uc) {
        for (Map.Entry header : headers.entrySet()) {
            List headerValues = (List)header.getValue();
            if (headerValues.size() == 1) {
                uc.setRequestProperty((String)header.getKey(), (String)headerValues.get(0));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (String value : headerValues) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append((Object)value);
            }
            uc.setRequestProperty((String)header.getKey(), b.toString());
        }
    }

    private static void setRequestMethodViaJreBugWorkaround(HttpURLConnection httpURLConnection, String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            try {
                Class<?> httpURLConnectionClass = httpURLConnection.getClass();
                Field methodField = httpURLConnectionClass.getSuperclass().getDeclaredField("method");
                methodField.setAccessible(true);
                methodField.set(httpURLConnection, method);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getName() {
        return "HttpUrlConnection " + System.getProperty("java.version");
    }

    public static interface ConnectionFactory {
        public HttpURLConnection getConnection(URL var1) throws IOException;
    }
}

