/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.internal.LocalizationMessages;

public class UriInfoInjectee
implements UriInfo {
    private UriInfo wrapped;

    public void set(UriInfo uriInfo) {
        if (this.wrapped != null) {
            throw new IllegalStateException(LocalizationMessages.URI_INFO_WAS_ALREADY_SET());
        }
        this.wrapped = uriInfo;
    }

    @Override
    public URI getRequestUri() {
        this.checkStatus();
        return this.wrapped.getRequestUri();
    }

    @Override
    public String getPath() {
        this.checkStatus();
        return this.wrapped.getPath();
    }

    @Override
    public String getPath(boolean decode) {
        this.checkStatus();
        return this.wrapped.getPath(decode);
    }

    @Override
    public List<PathSegment> getPathSegments() {
        this.checkStatus();
        return this.wrapped.getPathSegments();
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        this.checkStatus();
        return this.wrapped.getPathSegments(decode);
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        this.checkStatus();
        return this.wrapped.getRequestUriBuilder();
    }

    @Override
    public URI getAbsolutePath() {
        this.checkStatus();
        return this.wrapped.getAbsolutePath();
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        this.checkStatus();
        return this.wrapped.getAbsolutePathBuilder();
    }

    @Override
    public URI getBaseUri() {
        this.checkStatus();
        return this.wrapped.getBaseUri();
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        this.checkStatus();
        return this.wrapped.getBaseUriBuilder();
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        this.checkStatus();
        return this.wrapped.getPathParameters();
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        this.checkStatus();
        return this.wrapped.getPathParameters(decode);
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        this.checkStatus();
        return this.wrapped.getQueryParameters();
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        this.checkStatus();
        return this.wrapped.getQueryParameters(decode);
    }

    @Override
    public List<String> getMatchedURIs() {
        this.checkStatus();
        return this.wrapped.getMatchedURIs();
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        this.checkStatus();
        return this.wrapped.getMatchedURIs(decode);
    }

    @Override
    public List<Object> getMatchedResources() {
        this.checkStatus();
        return this.wrapped.getMatchedResources();
    }

    @Override
    public URI resolve(URI uri) {
        this.checkStatus();
        return this.wrapped.resolve(uri);
    }

    @Override
    public URI relativize(URI uri) {
        this.checkStatus();
        return this.wrapped.relativize(uri);
    }

    private void checkStatus() throws IllegalStateException {
        if (this.wrapped == null) {
            throw new IllegalStateException(LocalizationMessages.URI_INFO_WAS_NOT_SET());
        }
    }
}

