/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class CloseableServiceBinder
extends AbstractBinder {
    protected void configure() {
        this.bind(DefaultCloseableService.class).to(CloseableService.class).in(RequestScoped.class);
    }

    private static class DefaultCloseableService
    implements CloseableService {
        private static final Logger LOGGER = Logger.getLogger(DefaultCloseableService.class.getName());
        private final ContainerRequest containerRequest;

        @Inject
        public DefaultCloseableService(ContainerRequest containerRequest) {
            this.containerRequest = containerRequest;
        }

        @Override
        public void add(Closeable c) {
            Set<Closeable> closeableSet = this.getCloseables();
            if (closeableSet == null) {
                closeableSet = new HashSet<Closeable>();
                this.containerRequest.setProperty(DefaultCloseableService.class.getName(), closeableSet);
            }
            closeableSet.add(c);
        }

        @Override
        public void close() {
            Set<Closeable> closeableSet = this.getCloseables();
            if (closeableSet != null) {
                for (Closeable c : closeableSet) {
                    try {
                        c.close();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.CLOSEABLE_UNABLE_TO_CLOSE(c.getClass().getName()), ex);
                    }
                }
            }
        }

        private Set<Closeable> getCloseables() {
            if (this.containerRequest == null) {
                LOGGER.warning(LocalizationMessages.CLOSEABLE_INJECTED_REQUEST_CONTEXT_NULL(Thread.currentThread().getName()));
                return null;
            }
            return (Set)this.containerRequest.getProperty(DefaultCloseableService.class.getName());
        }
    }
}

