/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.internal.AbstractJavaResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

class JavaResourceMethodDispatcherProvider
implements ResourceMethodDispatcher.Provider {
    @Inject
    private ServiceLocator serviceLocator;

    JavaResourceMethodDispatcherProvider() {
    }

    @Override
    public ResourceMethodDispatcher create(Invocable resourceMethod, InvocationHandler invocationHandler) {
        List<Factory<?>> valueProviders = resourceMethod.getValueProviders(this.serviceLocator);
        Class<?> returnType = resourceMethod.getHandlingMethod().getReturnType();
        AbstractMethodParamInvoker resourceMethodDispatcher = Response.class.isAssignableFrom(returnType) ? new ResponseOutInvoker(resourceMethod, invocationHandler, valueProviders) : (returnType != Void.TYPE ? (returnType == Object.class || GenericEntity.class.isAssignableFrom(returnType) ? new ObjectOutInvoker(resourceMethod, invocationHandler, valueProviders) : new TypeOutInvoker(resourceMethod, invocationHandler, valueProviders)) : new VoidOutInvoker(resourceMethod, invocationHandler, valueProviders));
        this.serviceLocator.inject((Object)resourceMethodDispatcher);
        return resourceMethodDispatcher;
    }

    final ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    private static final class TypeOutInvoker
    extends AbstractMethodParamInvoker {
        private final Type t;

        public TypeOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
            this.t = resourceMethod.getHandlingMethod().getGenericReturnType();
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            Object o = this.invoke(resource, this.getParamValues());
            if (o != null) {
                Response response = Response.ok().entity(o).build();
                return response;
            }
            return Response.noContent().build();
        }
    }

    private static final class ObjectOutInvoker
    extends AbstractMethodParamInvoker {
        public ObjectOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            Object o = this.invoke(resource, this.getParamValues());
            if (o instanceof Response) {
                return (Response)Response.class.cast(o);
            }
            if (o != null) {
                return Response.ok().entity(o).build();
            }
            return Response.noContent().build();
        }
    }

    private static final class ResponseOutInvoker
    extends AbstractMethodParamInvoker {
        public ResponseOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            return (Response)Response.class.cast(this.invoke(resource, this.getParamValues()));
        }
    }

    private static final class VoidOutInvoker
    extends AbstractMethodParamInvoker {
        public VoidOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            this.invoke(resource, this.getParamValues());
            return Response.noContent().build();
        }
    }

    private static abstract class AbstractMethodParamInvoker
    extends AbstractJavaResourceMethodDispatcher {
        private final List<Factory<?>> valueProviders;

        public AbstractMethodParamInvoker(Invocable resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler);
            this.valueProviders = valueProviders;
        }

        final Object[] getParamValues() {
            return ParameterValueHelper.getParameterValues(this.valueProviders);
        }
    }
}

