/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.webservices.AdapterInvocationInfo;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WsUtil;

public class Ejb3MessageDispatcher
implements EjbMessageDispatcher {
    private static final Logger logger = LogUtils.getLogger();
    private static WsUtil wsUtil = new WsUtil();

    @Override
    public void invoke(HttpServletRequest req, HttpServletResponse resp, ServletContext ctxt, EjbRuntimeEndpointInfo endpointInfo) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "WS-JSR109IMPL-00047", new Object[]{req.getMethod(), req.getRequestURI(), req.getQueryString()});
        }
        String method = req.getMethod();
        try {
            if (method.equals("POST")) {
                this.handlePost(req, resp, endpointInfo);
            } else if (method.equals("GET")) {
                this.handleGet(req, resp, ctxt, endpointInfo);
            } else {
                String errorMessage = MessageFormat.format(logger.getResourceBundle().getString("WS-JSR109IMPL-00070"), method, endpointInfo.getEndpoint().getEndpointName(), endpointInfo.getEndpointAddressUri());
                logger.log(Level.WARNING, errorMessage);
                wsUtil.writeInvalidMethodType(resp, errorMessage);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "WS-JSR109IMPL-00048", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePost(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        AdapterInvocationInfo adapterInfo = null;
        try {
            try {
                adapterInfo = (AdapterInvocationInfo)endpointInfo.prepareInvocation(true);
                ServletAdapter adapter = adapterInfo.getAdapter();
                if (adapter != null) {
                    adapter.handle(null, req, resp);
                } else {
                    logger.log(Level.SEVERE, "WS-JSR109IMPL-00049", endpointInfo.getEndpoint().getName());
                }
                endpointInfo.releaseImplementor(adapterInfo == null ? null : adapterInfo.getInv());
            }
            catch (Throwable throwable) {
                endpointInfo.releaseImplementor(adapterInfo == null ? null : adapterInfo.getInv());
                throw throwable;
            }
        }
        catch (Throwable e) {
            String errorMessage = MessageFormat.format(logger.getResourceBundle().getString("WS-JSR109IMPL-00071"), endpointInfo.getEndpoint().getEndpointName(), endpointInfo.getEndpointAddressUri(), e.getMessage());
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp, ServletContext ctxt, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        try {
            AdapterInvocationInfo adapterInfo = (AdapterInvocationInfo)endpointInfo.prepareInvocation(true);
            ServletAdapter adapter = adapterInfo.getAdapter();
            if (adapter != null) {
                adapter.publishWSDL(ctxt, req, resp);
            } else {
                String message = "Invalid wsdl request " + req.getRequestURL();
                new WsUtil().writeInvalidMethodType(resp, message);
            }
        }
        catch (Throwable e) {
            String errorMessage = MessageFormat.format(logger.getResourceBundle().getString("WS-JSR109IMPL-00071"), endpointInfo.getEndpoint().getEndpointName(), endpointInfo.getEndpointAddressUri(), e.getMessage());
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
    }
}

