/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Application;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.ejb.spi.WSEjbEndpointRegistry;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.EjbMessageDispatcher;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceEjbEndpointRegistry;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.glassfish.webservices.monitoring.WebServiceTesterServlet;

public class EjbWebServiceServlet
extends HttpServlet {
    private static final Logger logger = LogUtils.getLogger();
    private SecurityService secServ;

    public EjbWebServiceServlet() {
        if (Globals.getDefaultHabitat() != null) {
            this.secServ = (SecurityService)Globals.get(SecurityService.class);
        }
    }

    protected void service(HttpServletRequest hreq, HttpServletResponse hresp) throws ServletException, IOException {
        WebServiceEjbEndpointRegistry wsejbEndpointRegistry;
        EjbRuntimeEndpointInfo ejbEndpoint;
        boolean dispatch = true;
        String requestUriRaw = hreq.getRequestURI();
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        String query = hreq.getQueryString();
        if ("Tester".equalsIgnoreCase(query)) {
            Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(hreq.getRequestURI());
            if (endpoint.getDescriptor().isSecure() || endpoint.getDescriptor().getMessageSecurityBinding() != null) {
                String message = endpoint.getDescriptor().getWebService().getName() + "is a secured web service; Tester feature is not supported for secured services";
                new WsUtil().writeInvalidMethodType(hresp, message);
                return;
            }
            if (Boolean.parseBoolean(endpoint.getDescriptor().getDebugging())) {
                dispatch = false;
                WebServiceTesterServlet.invoke(hreq, hresp, endpoint.getDescriptor());
            }
        }
        if (dispatch && (ejbEndpoint = (wsejbEndpointRegistry = (WebServiceEjbEndpointRegistry)Globals.getDefaultHabitat().getService(WSEjbEndpointRegistry.class, new Annotation[0])).getEjbWebServiceEndpoint(requestUri, hreq.getMethod(), query)) != null) {
            this.dispatchToEjbEndpoint(hreq, hresp, ejbEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToEjbEndpoint(HttpServletRequest hreq, HttpServletResponse hresp, EjbRuntimeEndpointInfo ejbEndpoint) {
        String expectedScheme;
        String scheme = hreq.getScheme();
        String string = expectedScheme = ejbEndpoint.getEndpoint().isSecure() ? "https" : "http";
        if (!expectedScheme.equalsIgnoreCase(scheme)) {
            logger.log(Level.WARNING, "WS-JSR109IMPL-00076", new Object[]{ejbEndpoint.getEndpoint().getEndpointName(), expectedScheme, scheme});
            return;
        }
        EjbEndpointFacade container = ejbEndpoint.getContainer();
        ClassLoader savedClassLoader = null;
        boolean authenticated = false;
        try {
            savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(container.getEndpointClassLoader());
            String realmName = null;
            Application app = ejbEndpoint.getEndpoint().getBundleDescriptor().getApplication();
            if (app != null) {
                realmName = app.getRealm();
            }
            if (realmName == null) {
                realmName = ejbEndpoint.getEndpoint().getRealm();
            }
            if (realmName == null) {
                realmName = hreq.getServerName() + ":" + hreq.getServerPort();
            }
            try {
                if (this.secServ != null) {
                    WebServiceContextImpl context = (WebServiceContextImpl)ejbEndpoint.getWebServiceContext();
                    authenticated = this.secServ.doSecurity(hreq, ejbEndpoint, realmName, context);
                }
            }
            catch (Exception e) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("WS-JSR109IMPL-00077"), ejbEndpoint.getEndpoint().getEndpointName());
                logger.log(Level.WARNING, msg, e);
            }
            if (!authenticated) {
                hresp.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
                hresp.sendError(401);
                return;
            }
            EjbMessageDispatcher msgDispatcher = ejbEndpoint.getMessageDispatcher();
            msgDispatcher.invoke(hreq, hresp, this.getServletContext(), ejbEndpoint);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "WS-JSR109IMPL-00050", t);
        }
        finally {
            if (this.secServ != null) {
                this.secServ.resetSecurityContext();
                this.secServ.resetPolicyContext();
            }
            Thread.currentThread().setContextClassLoader(savedClassLoader);
        }
    }
}

