/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.xml.ws.WebServiceException;
import org.glassfish.ejb.api.EjbEndpointFacade;
import org.glassfish.ejb.spi.WSEjbEndpointRegistry;
import org.glassfish.webservices.Ejb2RuntimeEndpointInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class WebServiceEjbEndpointRegistry
implements WSEjbEndpointRegistry {
    private static final Logger logger = LogUtils.getLogger();
    private Hashtable webServiceEjbEndpoints = new Hashtable();
    private Set ejbContextRoots = new HashSet();
    private HashMap adapterListMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(WebServiceEndpoint webserviceEndpoint, EjbEndpointFacade ejbContainer, Object servant, Class tieClass) {
        String uri = null;
        EjbRuntimeEndpointInfo endpoint = this.createEjbEndpointInfo(webserviceEndpoint, ejbContainer, servant, tieClass);
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            String uriRaw = endpoint.getEndpointAddressUri();
            if (uriRaw != null) {
                String string = uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
                if (this.webServiceEjbEndpoints.containsKey(uri)) {
                    logger.log(Level.SEVERE, "WS-JSR109IMPL-00034", uri);
                }
                this.webServiceEjbEndpoints.put(uri, endpoint);
                this.regenerateEjbContextRoots();
                if (this.adapterListMap.get(uri) == null) {
                    ServletAdapterList list = new ServletAdapterList();
                    this.adapterListMap.put(uri, list);
                }
            } else {
                throw new WebServiceException(logger.getResourceBundle().getString("WS-JSR109IMPL-00056"));
            }
        }
        WebServiceEngineImpl engine = WebServiceEngineImpl.getInstance();
        if (endpoint.getEndpoint().getWebService().getMappingFileUri() != null) {
            engine.createHandler(null, endpoint.getEndpoint());
        } else {
            engine.createHandler(endpoint.getEndpoint());
            try {
                endpoint.initRuntimeInfo((ServletAdapterList)this.adapterListMap.get(uri));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "WS-JSR109IMPL-00088", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEndpoint(String endpointAddressUri) {
        EjbRuntimeEndpointInfo endpoint = null;
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            String uriRaw = endpointAddressUri;
            String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
            ServletAdapterList list = (ServletAdapterList)this.adapterListMap.get(uri);
            if (list != null) {
                for (ServletAdapter x : list) {
                    x.getEndpoint().dispose();
                }
                this.adapterListMap.remove(uri);
            }
            endpoint = (EjbRuntimeEndpointInfo)this.webServiceEjbEndpoints.remove(uri);
            this.regenerateEjbContextRoots();
        }
        if (endpoint == null) {
            return;
        }
        WebServiceEngineImpl engine = WebServiceEngineImpl.getInstance();
        engine.removeHandler(endpoint.getEndpoint());
    }

    public EjbRuntimeEndpointInfo createEjbEndpointInfo(WebServiceEndpoint webServiceEndpoint, EjbEndpointFacade ejbContainer, Object servant, Class tieClass) {
        EjbRuntimeEndpointInfo info = null;
        info = webServiceEndpoint.getWebService().hasMappingFile() ? new Ejb2RuntimeEndpointInfo(webServiceEndpoint, ejbContainer, servant, tieClass) : new EjbRuntimeEndpointInfo(webServiceEndpoint, ejbContainer, servant);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbRuntimeEndpointInfo getEjbWebServiceEndpoint(String uriRaw, String method, String query) {
        EjbRuntimeEndpointInfo endpoint = null;
        if (uriRaw == null || uriRaw.length() == 0) {
            return null;
        }
        String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            if (method.equals("GET")) {
                String contextRoot = this.getContextRootForUri(uri);
                if (this.ejbContextRoots.contains(contextRoot)) {
                    Collection values = this.webServiceEjbEndpoints.values();
                    for (EjbRuntimeEndpointInfo next : values) {
                        if (!next.getEndpoint().matchesEjbPublishRequest(uri, query)) continue;
                        endpoint = next;
                        break;
                    }
                }
            } else {
                endpoint = (EjbRuntimeEndpointInfo)this.webServiceEjbEndpoints.get(uri);
            }
        }
        return endpoint;
    }

    public Collection getEjbWebServiceEndpoints() {
        return this.webServiceEjbEndpoints.entrySet();
    }

    private String getContextRootForUri(String uri) {
        StringTokenizer tokenizer = new StringTokenizer(uri, "/");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateEjbContextRoots() {
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            HashSet<String> contextRoots = new HashSet<String>();
            for (String uri : this.webServiceEjbEndpoints.keySet()) {
                String contextRoot = this.getContextRootForUri(uri);
                if (contextRoot == null || contextRoot.equals("")) continue;
                contextRoots.add(contextRoot);
            }
            this.ejbContextRoots = contextRoots;
        }
    }
}

