/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.servlet.ServletHandler;
import org.glassfish.web.deployment.util.WebServerInfo;
import org.glassfish.webservices.EjbWSAdapter;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WsUtil;

public class WebServicesApplication
implements ApplicationContainer {
    private ArrayList<EjbEndpoint> ejbendpoints;
    private ServletHandler httpHandler;
    private final RequestDispatcher dispatcher;
    private DeploymentContext deploymentCtx;
    private static final Logger logger = LogUtils.getLogger();
    private ClassLoader cl;
    private Application app;
    private Set<String> publishedFiles;

    public WebServicesApplication(DeploymentContext context, RequestDispatcher dispatcherString, Set<String> publishedFiles) {
        this.deploymentCtx = context;
        this.dispatcher = dispatcherString;
        this.ejbendpoints = this.getEjbEndpoints();
        this.httpHandler = new EjbWSAdapter();
        this.publishedFiles = publishedFiles;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        this.cl = startupContext.getClassLoader();
        try {
            this.app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
            DeployCommandParameters commandParams = (DeployCommandParameters)((DeploymentContext)startupContext).getCommandParameters(DeployCommandParameters.class);
            String virtualServers = commandParams.virtualservers;
            Iterator<EjbEndpoint> iter = this.ejbendpoints.iterator();
            EjbEndpoint ejbendpoint = null;
            while (iter.hasNext()) {
                ejbendpoint = iter.next();
                String contextRoot = ejbendpoint.contextRoot;
                WebServerInfo wsi = new WsUtil().getWebServerInfoForDAS();
                URL rootURL = wsi.getWebServerRootURL(ejbendpoint.isSecure);
                this.dispatcher.registerEndpoint(contextRoot, (HttpHandler)this.httpHandler, (ApplicationContainer)this, virtualServers);
                if (wsi.getHttpVS() == null || wsi.getHttpVS().getPort() == 0) continue;
                logger.log(Level.INFO, "WS-JSR109IMPL-00019", new Object[]{this.app.getAppName(), rootURL + contextRoot});
            }
        }
        catch (EndpointRegistrationException e) {
            logger.log(Level.SEVERE, "WS-JSR109IMPL-00054", e.toString());
        }
        return true;
    }

    private ArrayList<EjbEndpoint> getEjbEndpoints() {
        this.ejbendpoints = new ArrayList();
        Application app = (Application)this.deploymentCtx.getModuleMetaData(Application.class);
        Set bundles = app.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.collectEjbEndpoints(bundle);
        }
        return this.ejbendpoints;
    }

    private void collectEjbEndpoints(BundleDescriptor bundleDesc) {
        WebServicesDescriptor wsDesc = bundleDesc.getWebServices();
        for (WebService ws : wsDesc.getWebServices()) {
            for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
                if (!endpoint.implementedByEjbComponent()) continue;
                this.ejbendpoints.add(new EjbEndpoint(endpoint.getEndpointAddressUri(), endpoint.isSecure()));
            }
        }
        for (EjbBundleDescriptor ejbD : bundleDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)) {
            this.collectEjbEndpoints((BundleDescriptor)ejbD);
        }
    }

    public boolean stop(ApplicationContext stopContext) {
        try {
            for (EjbEndpoint endpoint : this.ejbendpoints) {
                String contextRoot = endpoint.contextRoot;
                this.dispatcher.unregisterEndpoint(contextRoot);
            }
        }
        catch (EndpointRegistrationException e) {
            logger.log(Level.SEVERE, "WS-JSR109IMPL-00055", e.toString());
            return false;
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() throws Exception {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    Application getApplication() {
        return this.app;
    }

    Set<String> getPublishedFiles() {
        return this.publishedFiles;
    }

    static class EjbEndpoint {
        private final String contextRoot;
        private boolean isSecure;

        EjbEndpoint(String contextRoot, boolean secure) {
            this.contextRoot = contextRoot;
            this.isSecure = secure;
        }
    }
}

