/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.tools.ws.spi.WSToolsObjectFactory;
import com.sun.xml.bind.api.JAXBRIContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebService;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.MessageListener;
import org.glassfish.webservices.monitoring.MessageTrace;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class WebServiceTesterServlet
extends HttpServlet
implements MessageListener {
    private WebServiceEndpoint svcEP;
    private static final Logger logger = LogUtils.getLogger();
    private static Hashtable<String, Class> gsiClasses = new Hashtable();
    private static Hashtable<String, Object> ports = new Hashtable();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServiceTesterServlet.class);
    private volatile transient MessageTrace request = null;
    private volatile transient MessageTrace response = null;

    public static void invoke(HttpServletRequest request, HttpServletResponse response, WebServiceEndpoint endpoint) {
        try {
            WebServiceTesterServlet servlet = new WebServiceTesterServlet(endpoint);
            response.setCharacterEncoding("UTF-8");
            if (request.getMethod().equalsIgnoreCase("GET")) {
                servlet.doGet(request, response);
            } else {
                servlet.doPost(request, response);
            }
        }
        catch (Exception e) {
            try {
                PrintWriter out = response.getWriter();
                out.print("<HTML lang=" + Locale.getDefault().getLanguage() + "><HEAD><TITLE>" + localStrings.getLocalString("enterprise.webservice.monitoring.methodInvocationException", "Method invocation exception") + "</TITLE></HEAD>");
                out.print("<H3>" + localStrings.getLocalString("enterprise.webservice.monitoring.ExceptionDetails", "Exceptions details : {0}", new Object[]{e.getMessage()}) + "</H3>");
                out.print("<HR>");
                e.printStackTrace(out);
                out.print("<HR>");
                out.print("</HTML>");
                out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public WebServiceTesterServlet(WebServiceEndpoint ep) {
        this.svcEP = ep;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Method[] methods;
        res.setContentType("text/html");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        String requestURL = req.getRequestURL().toString();
        Endpoint myEndpoint = this.svcEP.implementedByWebComponent() ? WebServiceEngineImpl.getInstance().getEndpoint(req.getServletPath()) : WebServiceEngineImpl.getInstance().getEndpoint(req.getRequestURI());
        String seiClassName = myEndpoint.getDescriptor().getServiceEndpointInterface();
        ClassLoader testerCL = this.svcEP.getWebService().getBundleDescriptor().getClassLoader();
        if (testerCL != null) {
            Thread.currentThread().setContextClassLoader(testerCL);
        }
        try {
            Class<?> seiClass = Thread.currentThread().getContextClassLoader().loadClass(seiClassName);
            if (seiClass.getAnnotation(WebService.class) == null) {
                this.testerNotSupportedError(myEndpoint.getDescriptor().getServiceName(), out);
                return;
            }
        }
        catch (ClassNotFoundException clnfEx) {
            this.classNotAccessibleError(Thread.currentThread().getContextClassLoader(), seiClassName, out);
            return;
        }
        this.initializePort(req, res);
        Class clientSEI = gsiClasses.get(requestURL);
        out.print("<HTML lang=" + Locale.getDefault().getLanguage() + "><HEAD><TITLE>" + myEndpoint.getDescriptor().getServiceName().getLocalPart() + " " + localStrings.getLocalString("enterprise.webservice.monitoring.title", "Web Service Tester") + "</TITLE></HEAD>");
        out.print("<BODY><H1>" + myEndpoint.getDescriptor().getServiceName().getLocalPart() + " " + localStrings.getLocalString("enterprise.webservice.monitoring.title", "Web Service Tester") + "</H1>");
        boolean isInternetExplorer = false;
        String userAgent = req.getHeader("user-agent");
        if (userAgent != null) {
            isInternetExplorer = userAgent.indexOf("MSIE") != -1;
        }
        StringBuffer sb = new StringBuffer(URLDecoder.decode(requestURL));
        sb.append("?WSDL");
        out.print("<br>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.line1", "This form will allow you to test your web service implementation (<A HREF=\"{0}\" title=\"WSDL file describing {1} web service\">WSDL File</A>)", new Object[]{sb.toString(), myEndpoint.getDescriptor().getServiceName().getLocalPart()}));
        out.print("<hr>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.line2", "To invoke an operation, fill the method parameter(s) input boxes and click on the button labeled with the method name."));
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methods", "<H3>Methods :</H3>"));
        for (Method m : methods = clientSEI.getMethods()) {
            out.print("<FORM METHOD=\"POST\">");
            out.print(m.toString());
            out.print("<BR>");
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.formSubmit", "<INPUT TYPE=SUBMIT NAME=action title=\"Invoke {0} operation\" value={0}>", new Object[]{m.getName()}));
            out.print(" (");
            Class<?>[] parameters = m.getParameterTypes();
            for (int i = 0; i < parameters.length; ++i) {
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.formInput", "<INPUT TYPE=TEXT NAME=PARAM{0}{1} title=\"{0} parameter of type {2}\">", new Object[]{m.getName(), i, parameters[i].getName()}));
                if (i == parameters.length - 1) continue;
                out.print(",");
            }
            out.print(")");
            out.print("<BR>");
            out.print("<HR>");
            out.print("</FORM></BODY></HTML>");
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        String requestURL = req.getRequestURL().toString();
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.postTitle", "<HTML lang={0}><HEAD><TITLE>Method invocation trace</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        String operationName = req.getParameter("action");
        try {
            Endpoint myEndpoint = this.svcEP.implementedByWebComponent() ? WebServiceEngineImpl.getInstance().getEndpoint(req.getServletPath()) : WebServiceEngineImpl.getInstance().getEndpoint(req.getRequestURI());
            Class clientSEI = gsiClasses.get(requestURL);
            if (clientSEI == null) {
                this.initializePort(req, res);
                clientSEI = gsiClasses.get(requestURL);
            }
            Object port = ports.get(requestURL);
            Method[] methods = clientSEI.getMethods();
            Method toInvoke = null;
            for (Method m : methods) {
                if (!String.valueOf(m.getName()).equals(operationName)) continue;
                toInvoke = m;
            }
            if (toInvoke == null) {
                out.print("cannot  \"action\" request parameter method");
            } else {
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methodInvocation", "<H2><A> {0} </A> Method invocation</H2><BR><HR>", new Object[]{toInvoke.getName()}));
                myEndpoint.addListener(this);
                Class<?>[] parameterTypes = toInvoke.getParameterTypes();
                Object[] parameterValues = new Object[parameterTypes.length];
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methodTrace", "<h4>Method parameter(s)</h4>"));
                out.print("<table border=\"1\">");
                out.print("<tr>");
                out.print("<th>Type</th>");
                out.print("<th>Value</th>");
                out.print("</tr>");
                for (int i = 0; i < parameterTypes.length; ++i) {
                    out.print("<tr>");
                    String webValue = req.getParameter("PARAM" + toInvoke.getName() + i);
                    out.print("<td>" + parameterTypes[i].getName() + "</td>");
                    out.print("<td><pre>" + this.encodeHTML(webValue) + "</pre></td>");
                    parameterValues[i] = this.convertWebParam(parameterTypes[i], webValue);
                    out.print("</tr>");
                }
                out.print("</table>");
                out.print("<HR>");
                out.print(localStrings.getLocalString("enterprise.webservice.monitoring.methodReturn", "<h4>Method returned</h4>") + toInvoke.getReturnType().getName() + " : \"<b>" + this.encodeHTML(toInvoke.invoke(port, parameterValues).toString()) + "</b>\"");
                out.print("<HR>");
                if (this.request != null) {
                    out.print(localStrings.getLocalString("enterprise.webservice.monitoring.soapReq", "<h4>SOAP Request</h4>"));
                    this.dumpMessage(this.request, out);
                }
                if (toInvoke.getAnnotation(Oneway.class) == null && this.response != null) {
                    out.print(localStrings.getLocalString("enterprise.webservice.monitoring.soapResp", "<h4>SOAP Response</h4>"));
                    this.dumpMessage(this.response, out);
                }
                myEndpoint.removeListener(this);
            }
        }
        catch (Throwable e) {
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.serviceExceptionError", "<H2>Service invocation threw an exception with message : {0}; Refer to the server log for more details</H2><BR><HR>", new Object[]{e.getMessage()}));
            throw new ServletException(e);
        }
        out.print("</HTML>");
        out.close();
    }

    private void dumpMessage(MessageTrace message, PrintWriter out) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(message.getMessage(true).getBytes());
        StreamSource ss = new StreamSource(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(baos);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(ss, sr);
        out.print("<HR><blockquote><pre xml:lang>");
        out.write(this.encodeHTML(baos.toString()));
        out.print("</pre></blockquote><HR>");
    }

    @Override
    public void invocationProcessed(MessageTrace request, MessageTrace response) {
        this.request = request;
        this.response = response;
    }

    private Object convertWebParam(Class targetParamType, String webValue) {
        Object convertedValue = null;
        if (webValue == null || webValue.length() == 0) {
            return null;
        }
        if (String.class.equals((Object)targetParamType)) {
            convertedValue = webValue;
        } else {
            try {
                if (Integer.TYPE.equals(targetParamType) || Integer.class.equals((Object)targetParamType)) {
                    convertedValue = Integer.valueOf(webValue);
                }
                if (Boolean.TYPE.equals(targetParamType) || Boolean.class.equals((Object)targetParamType)) {
                    convertedValue = Boolean.valueOf(webValue);
                }
                if (Character.TYPE.equals(targetParamType) || Character.class.equals((Object)targetParamType)) {
                    convertedValue = Character.valueOf(webValue.charAt(0));
                }
                if (Long.TYPE.equals(targetParamType) || Long.class.equals((Object)targetParamType)) {
                    convertedValue = Long.valueOf(webValue);
                }
                if (Float.TYPE.equals(targetParamType) || Float.class.equals((Object)targetParamType)) {
                    convertedValue = Float.valueOf(webValue);
                }
                if (Double.TYPE.equals(targetParamType) || Double.class.equals((Object)targetParamType)) {
                    convertedValue = Double.valueOf(webValue);
                }
                if (Byte.TYPE.equals(targetParamType) || Byte.class.equals((Object)targetParamType)) {
                    convertedValue = Byte.valueOf(webValue);
                }
                if (Short.TYPE.equals(targetParamType) || Short.class.equals((Object)targetParamType)) {
                    convertedValue = new Short(webValue);
                }
                if (StringBuffer.class.equals((Object)targetParamType)) {
                    convertedValue = new StringBuffer(webValue);
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Cannot convert " + webValue + " in " + targetParamType);
            }
        }
        return convertedValue;
    }

    private void classNotAccessibleError(ClassLoader cl, String className, PrintWriter out) {
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.CNFTitle", "<HTML lang={0}><HEAD><TITLE>Method invocation exception</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        if (cl == null) {
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.CNFServerError", "<H3>Internal server error, debugging is not available</H3>"));
        } else {
            out.print(localStrings.getLocalString("enterprise.webservice.monitoring.CNFerror2", "<H3>Cannot load class {0} - Verify class presence in bundle</H3>", new Object[]{className}));
        }
        out.print("<HR>");
        out.print("</HTML>");
        out.close();
    }

    private void testerNotSupportedError(QName svcName, PrintWriter out) {
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.TesterNSTitle", "<HTML lang={0}><HEAD><TITLE>Tester feature not supported</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        out.print("<BODY>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.TesterNSerror2", "Service {0} looks like a JAXRPC based webservice.", new Object[]{svcName}));
        out.print("<br><br>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.TesterNSdetail", "Please note that the tester feature is supported for JAXWS based webservices only"));
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    private void wsImportError(URL wsdlUrl, PrintWriter out) {
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.WsImportError", "<HTML lang={0}><HEAD><TITLE>WsImport error for the the following wsdl</TITLE></HEAD>", new Object[]{Locale.getDefault().getLanguage()}));
        out.print("<BODY>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.WsImportError2", "Error generating artifacts for the following WSDL {0}", new Object[]{wsdlUrl}));
        out.print("<br><br>");
        out.print(localStrings.getLocalString("enterprise.webservice.monitoring.WsImportError3", "Possible causes can beinvoking https when the application is not configured for security", new Object[]{wsdlUrl}));
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    private void initializePort(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String classesDir;
        String requestURL = req.getRequestURL().toString();
        Endpoint myEndpoint = this.svcEP.implementedByWebComponent() ? WebServiceEngineImpl.getInstance().getEndpoint(req.getServletPath()) : WebServiceEngineImpl.getInstance().getEndpoint(req.getRequestURI());
        QName serviceName = new QName(myEndpoint.getDescriptor().getWsdlPort().getNamespaceURI(), myEndpoint.getDescriptor().getWebService().getName());
        StringBuffer sb = new StringBuffer(URLDecoder.decode(requestURL));
        sb.append("?WSDL");
        URL[] urls = new URL[1];
        try {
            URL wsdlUrl = new URL(sb.toString());
            classesDir = this.wsImport(wsdlUrl);
            if (classesDir == null) {
                this.wsImportError(wsdlUrl, res.getWriter());
                return;
            }
            urls[0] = new File(classesDir).toURL();
        }
        catch (MalformedURLException mue) {
            throw new ServletException((Throwable)mue);
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader testerCL = new URLClassLoader(urls, currentLoader.getParent());
        try {
            Thread.currentThread().setContextClassLoader(testerCL);
            String serviceClassName = this.getServiceClass(JAXBRIContext.mangleNameToClassName((String)serviceName.getLocalPart()), classesDir);
            if (serviceClassName == null) {
                throw new RuntimeException("Service Class not generated as expected");
            }
            Class<?> serviceClass = testerCL.loadClass(serviceClassName);
            Service service = Service.create((URL)new URL(sb.toString()), (QName)serviceName);
            if (service == null) {
                throw new RuntimeException("Cannot load Service");
            }
            String portClassName = this.getPortClass(myEndpoint, serviceClass);
            if (portClassName == null) {
                throw new RuntimeException("Cannot find the correct port class.");
            }
            Class<?> portClass = testerCL.loadClass(portClassName);
            Object port = service.getPort(myEndpoint.getDescriptor().getWsdlPort(), portClass);
            if (port == null) {
                throw new RuntimeException("Cannot find the correct port class.");
            }
            ports.put(requestURL, port);
            gsiClasses.put(requestURL, portClass);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
            this.deleteDir(new File(classesDir));
        }
    }

    private String wsImport(URL wsdlLocation) throws IOException {
        File classesDir = new File(System.getProperty("java.io.tmpdir"));
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        ModulesRegistry modulesRegistry = wscImpl.getModulesRegistry();
        Collection modules1 = modulesRegistry.getModules();
        Iterator it = modules1.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append(classesDir.getAbsolutePath());
        String classpath1 = null;
        while (it.hasNext()) {
            Module m = (Module)it.next();
            String name = m.getName();
            if (!name.equals("com.sun.xml.ws") && !name.equals("com.sun.xml.bind")) continue;
            ModuleDefinition modDef = m.getModuleDefinition();
            URI[] location = modDef.getLocations();
            buf.append(File.pathSeparator).append(new File(location[0]).getAbsolutePath());
            classpath1 = buf.toString();
        }
        System.setProperty("java.class.path", classpath1);
        classesDir = File.createTempFile("jax-ws", "tester", classesDir);
        if (!classesDir.delete()) {
            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00109", classesDir);
        }
        if (!classesDir.mkdirs()) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00110", classesDir);
        }
        String[] wsimportArgs = new String[]{"-d", classesDir.getAbsolutePath(), "-keep", wsdlLocation.toExternalForm(), "-Xendorsed", "-target", "2.1", "-extension"};
        WSToolsObjectFactory tools = WSToolsObjectFactory.newInstance();
        logger.log(Level.INFO, "AS-WSJSR109IMPL-00111", wsdlLocation);
        boolean success = tools.wsimport((OutputStream)System.out, wsimportArgs);
        if (!success) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00113");
            return null;
        }
        logger.log(Level.INFO, "AS-WSJSR109IMPL-00112");
        return classesDir.getAbsolutePath();
    }

    private String getServiceClass(String serviceClassName, String classesDirPath) {
        File classesDir = new File(classesDirPath);
        if (!classesDir.exists()) {
            return null;
        }
        List<File> mycoll = this.getListOfFiles(classesDir);
        File[] classes = mycoll.toArray(new File[mycoll.size()]);
        String resolvedServiceClass = null;
        String svcClass = null;
        for (File f : classes) {
            if (f.getName().endsWith(serviceClassName + "_Service.class")) {
                resolvedServiceClass = f.getAbsolutePath().substring(classesDirPath.length() + 1);
                continue;
            }
            if (!f.getName().endsWith(serviceClassName + ".class")) continue;
            svcClass = f.getAbsolutePath().substring(classesDirPath.length() + 1);
        }
        if (resolvedServiceClass != null) {
            svcClass = resolvedServiceClass;
        }
        if (svcClass != null) {
            svcClass = svcClass.substring(0, svcClass.indexOf(".class"));
            return svcClass.replaceAll("\\" + File.separator, ".");
        }
        return null;
    }

    private String getPortClass(Endpoint ep, Class serviceClass) throws Exception {
        for (Method m : serviceClass.getMethods()) {
            WebEndpoint webEP = m.getAnnotation(WebEndpoint.class);
            if (webEP == null || webEP.name() == null || webEP.name().length() == 0) continue;
            String getPortMethodName = "get" + JAXBRIContext.mangleNameToClassName((String)webEP.name());
            Method getPortMethod = serviceClass.getMethod(getPortMethodName, null);
            return getPortMethod.getReturnType().getName();
        }
        return null;
    }

    private List<File> getListOfFiles(File path) {
        File[] files = path.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (File f : files) {
            if (f.isDirectory()) {
                result.addAll(this.getListOfFiles(f));
                continue;
            }
            result.add(f);
        }
        return result;
    }

    private void deleteDir(File path) {
        if (path.exists() && path.isFile()) {
            File[] files;
            for (File f : files = path.listFiles()) {
                if (f.isDirectory()) {
                    this.deleteDir(f);
                }
                assert (f.delete());
            }
            assert (path.delete());
        }
    }

    private String encodeHTML(String html) {
        return html.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

