// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.polyglot.FunctionProxyNode;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotExecuteNodeGen;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(FunctionProxyNode.class)
final class FunctionProxyNodeGen extends FunctionProxyNode {

    @CompilationFinal private volatile int state_;
    @Child private CachedData cached_cache;

    private FunctionProxyNodeGen(Class<?> receiverType, Method method) {
        super(receiverType, method);
    }

    @Override
    protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
        int state = state_;
        if (state != 0 /* is-active doCached(PolyglotLanguageContext, TruffleObject, Object[], Class<>, Type, PolyglotExecuteNode) */ && arg1Value instanceof TruffleObject) {
            TruffleObject arg1Value_ = (TruffleObject) arg1Value;
            CachedData s1_ = this.cached_cache;
            if (s1_ != null) {
                return doCached(arg0Value, arg1Value_, arg2Value, s1_.returnClass_, s1_.returnType_, s1_.executeNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            if (arg1Value instanceof TruffleObject) {
                TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                CachedData s1_ = super.insert(new CachedData());
                s1_.returnClass_ = (HostInteropReflect.getMethodReturnType(method));
                s1_.returnType_ = (HostInteropReflect.getMethodGenericReturnType(method));
                s1_.executeNode_ = s1_.insertAccessor((PolyglotExecuteNodeGen.create()));
                this.cached_cache = s1_;
                this.state_ = state = state | 0b1 /* add-active doCached(PolyglotLanguageContext, TruffleObject, Object[], Class<>, Type, PolyglotExecuteNode) */;
                lock.unlock();
                hasLock = false;
                return doCached(arg0Value, arg1Value_, arg2Value, s1_.returnClass_, s1_.returnType_, s1_.executeNode_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    public static FunctionProxyNode create(Class<?> receiverType, Method method) {
        return new FunctionProxyNodeGen(receiverType, method);
    }

    @GeneratedBy(FunctionProxyNode.class)
    private static final class CachedData extends Node {

        @CompilationFinal Class<?> returnClass_;
        @CompilationFinal Type returnType_;
        @Child PolyglotExecuteNode executeNode_;

        CachedData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
