/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.floreysoft.jmte.Engine;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.StaticEmailAlertSender;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.StreamRuleService;

public class FormattedEmailAlertSender
extends StaticEmailAlertSender
implements AlertSender {
    public static final String bodyTemplate = "##########\nDate: ${check_result.triggeredAt}\nStream ID: ${stream.id}\nStream title: ${stream.title}\n${if stream_url}Stream URL: ${stream_url}${end}\n\nTriggered condition: ${check_result.triggeredCondition}\n##########\n\nLast messages accounting for this alert:\n${if backlog_size > 0}${foreach backlog message}\n${message}\n${end}\n${else}<No backlog.>${end}\n\n";
    private Configuration pluginConfig;

    @Inject
    public FormattedEmailAlertSender(EmailConfiguration configuration, StreamRuleService streamRuleService, UserService userService) {
        super(configuration, streamRuleService, userService);
    }

    @Override
    public void initialize(Configuration configuration) {
        this.pluginConfig = configuration;
    }

    @Override
    protected String buildSubject(Stream stream, AlertCondition.CheckResult checkResult, EmailConfiguration config, List<Message> backlog) {
        String template = this.pluginConfig == null || this.pluginConfig.getString("subject") == null ? "Graylog alert for stream: ${stream.title}" : this.pluginConfig.getString("subject");
        Map<String, Object> model = this.getModel(stream, checkResult, backlog);
        Engine engine = new Engine();
        return engine.transform(template, model);
    }

    @Override
    protected String buildBody(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        String template = this.pluginConfig == null || this.pluginConfig.getString("body") == null ? bodyTemplate : this.pluginConfig.getString("body");
        Map<String, Object> model = this.getModel(stream, checkResult, backlog);
        Engine engine = new Engine();
        return engine.transform(template, model);
    }

    private Map<String, Object> getModel(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("stream", stream);
        model.put("check_result", checkResult);
        model.put("stream_url", this.buildStreamDetailsURL(this.configuration.getWebInterfaceUri(), checkResult, stream));
        if (backlog != null) {
            model.put("backlog", backlog);
            model.put("backlog_size", backlog.size());
        } else {
            model.put("backlog", Collections.emptyList());
            model.put("backlog_size", 0);
        }
        return model;
    }
}

