/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.MessageFormatter;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.StreamRuleService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticEmailAlertSender
implements AlertSender {
    private static final Logger LOG = LoggerFactory.getLogger(StaticEmailAlertSender.class);
    private final StreamRuleService streamRuleService;
    protected final EmailConfiguration configuration;
    private final UserService userService;

    @Inject
    public StaticEmailAlertSender(EmailConfiguration configuration, StreamRuleService streamRuleService, UserService userService) {
        this.configuration = configuration;
        this.streamRuleService = streamRuleService;
        this.userService = userService;
    }

    @Override
    public void initialize(Configuration configuration) {
    }

    @Override
    public void sendEmails(Stream stream, AlertCondition.CheckResult checkResult) throws TransportConfigurationException, EmailException {
        this.sendEmails(stream, checkResult, null);
    }

    private void sendEmail(String emailAddress, Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) throws TransportConfigurationException, EmailException {
        LOG.debug("Sending mail to " + emailAddress);
        if (!this.configuration.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled!");
        }
        SimpleEmail email = new SimpleEmail();
        email.setHostName(this.configuration.getHostname());
        email.setSmtpPort(this.configuration.getPort());
        if (this.configuration.isUseSsl()) {
            email.setSslSmtpPort(Integer.toString(this.configuration.getPort()));
        }
        if (this.configuration.isUseAuth()) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.configuration.getUsername(), this.configuration.getPassword()));
        }
        email.setSSLOnConnect(this.configuration.isUseSsl());
        email.setStartTLSEnabled(this.configuration.isUseTls());
        email.setFrom(this.configuration.getFromEmail());
        email.setSubject(this.buildSubject(stream, checkResult, this.configuration, backlog));
        email.setMsg(this.buildBody(stream, checkResult, backlog));
        email.addTo(emailAddress);
        email.send();
    }

    protected String buildSubject(Stream stream, AlertCondition.CheckResult checkResult, EmailConfiguration config, List<Message> backlog) {
        StringBuilder sb = new StringBuilder();
        if (config.getSubjectPrefix() != null && !config.getSubjectPrefix().isEmpty()) {
            sb.append(config.getSubjectPrefix()).append(" ");
        }
        sb.append("Graylog alert for stream: ").append(stream.getTitle());
        return sb.toString();
    }

    protected String buildBody(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        StringBuilder sb = new StringBuilder();
        sb.append(checkResult.getResultDescription());
        sb.append("\n\n");
        sb.append("##########\n");
        sb.append("Date: ").append(Tools.iso8601().toString()).append("\n");
        sb.append("Stream ID: ").append(stream.getId()).append("\n");
        sb.append("Stream title: ").append(stream.getTitle()).append("\n");
        if (this.configuration.getWebInterfaceUri() != null) {
            sb.append("Stream URL: ").append(this.buildStreamDetailsURL(this.configuration.getWebInterfaceUri(), checkResult, stream));
        }
        try {
            sb.append("Stream rules: ").append(this.streamRuleService.loadForStream(stream)).append("\n");
        }
        catch (NotFoundException e) {
            LOG.error("Unable to find stream rules for stream: " + stream.getId(), (Throwable)e);
        }
        sb.append("Alert triggered at: ").append(checkResult.getTriggeredAt()).append("\n");
        sb.append("Triggered condition: ").append(checkResult.getTriggeredCondition()).append("\n");
        sb.append("##########");
        if (backlog != null) {
            sb.append(this.buildBacklogSummary(backlog));
        }
        return sb.toString();
    }

    protected String buildStreamDetailsURL(URI baseUri, AlertCondition.CheckResult checkResult, Stream stream) {
        if (baseUri == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int time = 5;
        if (checkResult.getTriggeredCondition().getParameters().get("time") != null) {
            time = (Integer)checkResult.getTriggeredCondition().getParameters().get("time");
        }
        DateTime dateAlertEnd = checkResult.getTriggeredAt();
        DateTime dateAlertStart = dateAlertEnd.minusMinutes(time);
        String alertStart = Tools.getISO8601String((DateTime)dateAlertStart);
        String alertEnd = Tools.getISO8601String((DateTime)dateAlertEnd);
        sb.append(baseUri).append("/streams/").append(stream.getId()).append("/messages");
        sb.append("?rangetype=absolute&from=").append(alertStart).append("&to=").append(alertEnd).append("&q=*\n");
        return sb.toString();
    }

    protected String buildBacklogSummary(List<Message> backlog) {
        if (backlog == null || backlog.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        MessageFormatter messageFormatter = new MessageFormatter();
        sb.append("\n\nLast ");
        if (backlog.size() > 1) {
            sb.append(backlog.size()).append(" relevant messages:\n");
        } else {
            sb.append("relevant message:\n");
        }
        sb.append("======================\n\n");
        for (Message message : backlog) {
            sb.append(messageFormatter.formatForMail(message));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void sendEmails(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) throws TransportConfigurationException, EmailException {
        if (!this.configuration.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled!");
        }
        if (stream.getAlertReceivers() == null || stream.getAlertReceivers().isEmpty()) {
            throw new RuntimeException("Stream [" + stream + "] has no alert receivers.");
        }
        if (stream.getAlertReceivers().get("users") != null) {
            for (String username : (List)stream.getAlertReceivers().get("users")) {
                User user = this.userService.load(username);
                if (user == null || user.getEmail() == null || user.getEmail().isEmpty()) continue;
                this.sendEmail(user.getEmail(), stream, checkResult, backlog);
            }
        }
        if (stream.getAlertReceivers().get("emails") != null) {
            for (String email : (List)stream.getAlertReceivers().get("emails")) {
                if (email.isEmpty()) continue;
                this.sendEmail(email, stream, checkResult, backlog);
            }
        }
    }
}

