/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.google.common.collect.Lists;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.authc.pam.FirstSuccessfulStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.authz.ModularRealmAuthorizer;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.graylog2.Configuration;
import org.graylog2.security.MongoDbSessionDAO;
import org.graylog2.security.realm.AccessTokenAuthenticator;
import org.graylog2.security.realm.GraylogSimpleAccountRealm;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.security.realm.MongoDbAuthorizationRealm;
import org.graylog2.security.realm.PasswordAuthenticator;
import org.graylog2.security.realm.SessionAuthenticator;

public class DefaultSecurityManagerProvider
implements Provider<DefaultSecurityManager> {
    private static DefaultSecurityManager sm = null;

    @Inject
    public DefaultSecurityManagerProvider(MongoDbSessionDAO mongoDbSessionDAO, PasswordAuthenticator passwordAuthenticator, MongoDbAuthorizationRealm mongoDbAuthorizationRealm, LdapUserAuthenticator ldapUserAuthenticator, SessionAuthenticator sessionAuthenticator, AccessTokenAuthenticator accessTokenAuthenticator, Configuration configuration) {
        GraylogSimpleAccountRealm inMemoryRealm = new GraylogSimpleAccountRealm();
        inMemoryRealm.setCachingEnabled(false);
        inMemoryRealm.addRootAccount(configuration.getRootUsername(), configuration.getRootPasswordSha2());
        inMemoryRealm.setCredentialsMatcher((CredentialsMatcher)new HashedCredentialsMatcher("SHA-256"));
        passwordAuthenticator.setCachingEnabled(false);
        passwordAuthenticator.setCredentialsMatcher((CredentialsMatcher)new HashedCredentialsMatcher("SHA-1"));
        mongoDbAuthorizationRealm.setCachingEnabled(false);
        ldapUserAuthenticator.setCachingEnabled(false);
        sessionAuthenticator.setCachingEnabled(false);
        accessTokenAuthenticator.setCachingEnabled(false);
        sm = new DefaultSecurityManager((Collection)Lists.newArrayList((Object[])new Realm[]{sessionAuthenticator, accessTokenAuthenticator, ldapUserAuthenticator, passwordAuthenticator, inMemoryRealm}));
        Authenticator authenticator = sm.getAuthenticator();
        if (authenticator instanceof ModularRealmAuthenticator) {
            ((ModularRealmAuthenticator)authenticator).setAuthenticationStrategy((AuthenticationStrategy)new FirstSuccessfulStrategy());
        }
        sm.setAuthorizer((Authorizer)new ModularRealmAuthorizer((Collection)Lists.newArrayList((Object[])new Realm[]{mongoDbAuthorizationRealm, inMemoryRealm})));
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator(){

            public boolean isSessionStorageEnabled(Subject subject) {
                return subject.getSession(false) != null;
            }
        };
        sessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)sessionStorageEvaluator);
        sm.setSubjectDAO((SubjectDAO)subjectDAO);
        DefaultSessionManager defaultSessionManager = (DefaultSessionManager)sm.getSessionManager();
        defaultSessionManager.setSessionDAO((SessionDAO)mongoDbSessionDAO);
        defaultSessionManager.setDeleteInvalidSessions(true);
        defaultSessionManager.setCacheManager((CacheManager)new MemoryConstrainedCacheManager());
        SecurityUtils.setSecurityManager((SecurityManager)sm);
    }

    public DefaultSecurityManager get() {
        return sm;
    }
}

