/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.StringListConverter;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.mongodb.ServerAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbConfiguration.class);
    @Parameter(value="mongodb_useauth", required=true)
    private boolean useAuth = false;
    @Parameter(value="mongodb_user")
    private String user;
    @Parameter(value="mongodb_password")
    private String password;
    @Parameter(value="mongodb_database", required=true)
    private String database = "graylog2";
    @Parameter(value="mongodb_host", required=true)
    private String host = "127.0.0.1";
    @Parameter(value="mongodb_port", required=true, validator=InetPortValidator.class)
    private int port = 27017;
    @Parameter(value="mongodb_max_connections", validator=PositiveIntegerValidator.class)
    private int maxConnections = 1000;
    @Parameter(value="mongodb_threads_allowed_to_block_multiplier", validator=PositiveIntegerValidator.class)
    private int threadsAllowedToBlockMultiplier = 5;
    @Parameter(value="mongodb_replica_set", converter=StringListConverter.class)
    private List<String> replicaSet;

    public boolean isUseAuth() {
        return this.useAuth;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getThreadsAllowedToBlockMultiplier() {
        return this.threadsAllowedToBlockMultiplier;
    }

    public List<ServerAddress> getReplicaSet() {
        if (this.replicaSet == null || this.replicaSet.isEmpty()) {
            return null;
        }
        ArrayList<ServerAddress> replicaServers = new ArrayList<ServerAddress>(this.replicaSet.size());
        for (String host : this.replicaSet) {
            try {
                HostAndPort hostAndPort = HostAndPort.fromString((String)host).withDefaultPort(27017);
                replicaServers.add(new ServerAddress(InetAddress.getByName(hostAndPort.getHostText()), hostAndPort.getPort()));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Malformed mongodb_replica_set configuration.", (Throwable)e);
                return null;
            }
            catch (UnknownHostException e) {
                LOG.error("Unknown host in mongodb_replica_set", (Throwable)e);
                return null;
            }
        }
        return replicaServers;
    }

    @ValidatorMethod
    public void validate() throws ValidationException {
        if (this.isUseAuth() && (Strings.isNullOrEmpty((String)this.getUser()) || Strings.isNullOrEmpty((String)this.getPassword()))) {
            throw new ValidationException("mongodb_user and mongodb_password have to be set if mongodb_useauth is true");
        }
    }
}

