/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardService;

@Singleton
public class DashboardRegistry {
    private final DashboardService dashboardService;
    private final Map<String, Dashboard> dashboards = Maps.newHashMap();

    @Inject
    public DashboardRegistry(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    public void loadPersisted() {
        for (Dashboard dashboard : this.dashboardService.all()) {
            this.dashboards.put(dashboard.getId(), dashboard);
        }
    }

    public void add(Dashboard dashboard) {
        this.dashboards.put(dashboard.getId(), dashboard);
    }

    public Dashboard get(String dashboardId) {
        return this.dashboards.get(dashboardId);
    }

    public Map<String, Dashboard> getAll() {
        return Maps.newHashMap(this.dashboards);
    }

    public void remove(String dashboardId) {
        this.dashboards.remove(dashboardId);
    }
}

