/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardImpl;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.resources.dashboards.requests.WidgetPositions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardServiceImpl
extends PersistedServiceImpl
implements DashboardService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardServiceImpl.class);
    private final MetricRegistry metricRegistry;
    private final Searches searches;

    @Inject
    public DashboardServiceImpl(MongoConnection mongoConnection, MetricRegistry metricRegistry, Searches searches) {
        super(mongoConnection);
        this.metricRegistry = metricRegistry;
        this.searches = searches;
    }

    @Override
    public Dashboard load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(DashboardImpl.class, id);
        if (o == null) {
            throw new NotFoundException();
        }
        return new DashboardImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public List<Dashboard> all() {
        ArrayList dashboards = Lists.newArrayList();
        List<DBObject> results = this.query(DashboardImpl.class, (DBObject)new BasicDBObject());
        for (DBObject o : results) {
            Map fields = o.toMap();
            DashboardImpl dashboard = new DashboardImpl((ObjectId)o.get("_id"), fields);
            if (fields.containsKey("widgets")) {
                for (BasicDBObject widgetFields : (List)fields.get("widgets")) {
                    DashboardWidget widget = null;
                    try {
                        widget = DashboardWidget.fromPersisted(this.metricRegistry, this.searches, widgetFields);
                    }
                    catch (DashboardWidget.NoSuchWidgetTypeException e) {
                        LOG.error("No such widget type: [" + widgetFields.get("type") + "] - Dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                        continue;
                    }
                    catch (InvalidRangeParametersException e) {
                        LOG.error("Invalid range parameters of widget in dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                        continue;
                    }
                    catch (InvalidWidgetConfigurationException e) {
                        LOG.error("Invalid configuration of widget in dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                        continue;
                    }
                    dashboard.addPersistedWidget(widget);
                }
            }
            dashboards.add(dashboard);
        }
        return dashboards;
    }

    @Override
    public void updateWidgetPositions(Dashboard dashboard, WidgetPositions positions) throws ValidationException {
        HashMap map = Maps.newHashMap();
        for (WidgetPositions.WidgetPosition position : positions.positions()) {
            HashMap x = Maps.newHashMap();
            x.put("col", position.col());
            x.put("row", position.row());
            map.put(position.id(), x);
        }
        dashboard.getFields().put("positions", map);
        this.save(dashboard);
    }

    @Override
    public void addWidget(Dashboard dashboard, DashboardWidget widget) throws ValidationException {
        this.embed(dashboard, "widgets", widget);
        dashboard.addWidget(widget);
    }

    @Override
    public void removeWidget(Dashboard dashboard, DashboardWidget widget) {
        this.removeEmbedded(dashboard, "widgets", widget.getId());
        dashboard.removeWidget(widget);
    }

    @Override
    public void updateWidgetDescription(Dashboard dashboard, DashboardWidget widget, String newDescription) throws ValidationException {
        widget.setDescription(newDescription);
        this.removeWidget(dashboard, widget);
        this.addWidget(dashboard, widget);
    }

    @Override
    public void updateWidgetCacheTime(Dashboard dashboard, DashboardWidget widget, int cacheTime) throws ValidationException {
        widget.setCacheTime(cacheTime);
        this.removeWidget(dashboard, widget);
        this.addWidget(dashboard, widget);
    }

    @Override
    public long count() {
        return this.totalCount(DashboardImpl.class);
    }
}

