/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;

public class SearchResultChartWidget
extends DashboardWidget {
    private final String query;
    private final TimeRange timeRange;
    private final Searches.DateHistogramInterval interval;
    @Nullable
    private final String streamId;
    private final Searches searches;

    public SearchResultChartWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, int cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        super(metricRegistry, DashboardWidget.Type.SEARCH_RESULT_CHART, id, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        this.query = this.getNonEmptyQuery(query);
        this.timeRange = timeRange;
        this.streamId = (String)config.get("stream_id");
        this.interval = config.containsKey("interval") ? Searches.DateHistogramInterval.valueOf(((String)config.get("interval")).toUpperCase()) : Searches.DateHistogramInterval.MINUTE;
    }

    private String getNonEmptyQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return "*";
        }
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().put((Object)"query", (Object)this.query).put((Object)"interval", (Object)this.interval.toString().toLowerCase()).put((Object)"timerange", this.timeRange.getPersistedConfig());
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        HistogramResult histogram = this.searches.histogram(this.query, this.interval, filter, this.timeRange);
        return new ComputationResult(histogram.getResults(), histogram.took().millis(), histogram.getHistogramBoundaries());
    }
}

