/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.validators;

import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.plugin.database.validators.ValidationResult;

public class LimitedOptionalStringValidator
extends OptionalStringValidator {
    private int maxLength;

    public LimitedOptionalStringValidator(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public ValidationResult validate(Object value) {
        ValidationResult superResult = super.validate(value);
        if (superResult instanceof ValidationResult.ValidationPassed) {
            String sValue = (String)value;
            if (sValue == null || sValue.length() <= this.maxLength) {
                new ValidationResult.ValidationPassed();
            } else {
                new ValidationResult.ValidationFailed("Value is longer than " + this.maxLength + " characters!");
            }
        }
        return superResult;
    }
}

