/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.validators;

import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.plugin.database.validators.ValidationResult;

public class LimitedStringValidator
extends FilledStringValidator {
    private int minLength;
    private int maxLength;

    public LimitedStringValidator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public ValidationResult validate(Object value) {
        ValidationResult superResult = super.validate(value);
        if (superResult instanceof ValidationResult.ValidationPassed) {
            String sValue = (String)value;
            if (sValue.length() >= this.minLength && sValue.length() <= this.maxLength) {
                new ValidationResult.ValidationPassed();
            } else {
                new ValidationResult.ValidationFailed("Value is not between " + this.minLength + " and " + this.maxLength + " in length!");
            }
        }
        return superResult;
    }
}

