/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.filters.FilterService;
import org.graylog2.filters.blacklist.FilterDescription;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.plugin.filters.MessageFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RulesFilter.class);
    private final FilterService filterService;
    private final RulesEngine.RulesSession privateSession;
    private final Cache<String, Set<FilterDescription>> cache;
    private Set<FilterDescription> currentFilterSet;

    @Inject
    public RulesFilter(RulesEngine rulesEngine, FilterService filterService) {
        this.filterService = filterService;
        this.currentFilterSet = Sets.newHashSet();
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
        this.privateSession = rulesEngine.createPrivateSession();
    }

    public boolean filter(Message msg) {
        try {
            Set filters = (Set)this.cache.get((Object)"filters", (Callable)new Callable<Set<FilterDescription>>(){

                @Override
                public Set<FilterDescription> call() throws Exception {
                    Set<FilterDescription> newFilters = RulesFilter.this.filterService.loadAll();
                    Sets.SetView difference = Sets.symmetricDifference((Set)RulesFilter.this.currentFilterSet, newFilters);
                    if (difference.isEmpty()) {
                        LOG.debug("Filter sets are identical, not updating rules engine.");
                        return RulesFilter.this.currentFilterSet;
                    }
                    LOG.debug("Updating rules engine, filter sets differ: {}", (Object)difference);
                    for (FilterDescription filterDescription : RulesFilter.this.currentFilterSet) {
                        RulesFilter.this.privateSession.deleteFact((Object)filterDescription);
                    }
                    for (FilterDescription filterDescription : newFilters) {
                        RulesFilter.this.privateSession.insertFact((Object)filterDescription);
                    }
                    RulesFilter.this.currentFilterSet.clear();
                    RulesFilter.this.currentFilterSet.addAll(newFilters);
                    return RulesFilter.this.currentFilterSet;
                }
            });
        }
        catch (ExecutionException ignored) {
            return false;
        }
        this.privateSession.evaluate(msg, true);
        return msg.getFilterOut();
    }

    public String getName() {
        return "Rulesfilter";
    }

    public int getPriority() {
        return 30;
    }
}

