/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.filters.MessageFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFieldFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFieldFilter.class);
    private static final String NAME = "Static field appender";
    private final Cache<String, List<Map.Entry<String, String>>> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private final InputService inputService;

    @Inject
    public StaticFieldFilter(InputService inputService) {
        this.inputService = inputService;
    }

    public boolean filter(Message msg) {
        if (msg.getSourceInputId() == null) {
            return false;
        }
        for (Map.Entry<String, String> field : this.loadStaticFields(msg.getSourceInputId())) {
            if (!msg.hasField(field.getKey())) {
                msg.addField(field.getKey(), (Object)field.getValue());
                continue;
            }
            LOG.debug("Message already contains field [{}]. Not overwriting.", (Object)field.getKey());
        }
        return false;
    }

    private List<Map.Entry<String, String>> loadStaticFields(final String inputId) {
        try {
            return (List)this.cache.get((Object)inputId, (Callable)new Callable<List<Map.Entry<String, String>>>(){

                @Override
                public List<Map.Entry<String, String>> call() throws Exception {
                    LOG.debug("Re-loading static fields for input <{}> into cache.", (Object)inputId);
                    try {
                        Input input = StaticFieldFilter.this.inputService.find(inputId);
                        return StaticFieldFilter.this.inputService.getStaticFields(input);
                    }
                    catch (NotFoundException e) {
                        LOG.warn("Unable to load input: {}", (Object)e.getMessage());
                        return Collections.emptyList();
                    }
                }
            });
        }
        catch (ExecutionException e) {
            LOG.error("Could not load static fields into cache. Returning empty list.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getName() {
        return NAME;
    }

    public int getPriority() {
        return 20;
    }
}

