/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.client.Client;

public class Mapping {
    public static PutMappingRequest getPutMappingRequest(Client client, String index, String analyzer) {
        PutMappingRequestBuilder builder = client.admin().indices().preparePutMapping(new String[]{index});
        builder.setType("message");
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("properties", Mapping.partFieldProperties(analyzer));
        mapping.put("dynamic_templates", Mapping.partDefaultAllInDynamicTemplate());
        mapping.put("_source", Mapping.enabledAndCompressed());
        mapping.put("_ttl", Mapping.enabled());
        HashMap completeMapping = Maps.newHashMap();
        completeMapping.put("message", mapping);
        builder.setSource((Map)completeMapping);
        return (PutMappingRequest)builder.request();
    }

    private static List partDefaultAllInDynamicTemplate() {
        LinkedList dynamicTemplates = new LinkedList();
        HashMap template = new HashMap();
        HashMap<String, Object> defaultAll = new HashMap<String, Object>();
        HashMap<String, String> notAnalyzed = new HashMap<String, String>();
        notAnalyzed.put("index", "not_analyzed");
        defaultAll.put("match", "*");
        defaultAll.put("mapping", notAnalyzed);
        template.put("store_generic", defaultAll);
        dynamicTemplates.add(template);
        return dynamicTemplates;
    }

    private static Map partFieldProperties(String analyzer) {
        HashMap properties = Maps.newHashMap();
        properties.put("message", Mapping.analyzedString(analyzer));
        properties.put("full_message", Mapping.analyzedString(analyzer));
        properties.put("timestamp", Mapping.typeTimeWithMillis());
        properties.put("source", Mapping.analyzedString("analyzer_keyword"));
        return properties;
    }

    private static Map<String, String> analyzedString(String analyzer) {
        HashMap type = Maps.newHashMap();
        type.put("index", "analyzed");
        type.put("type", "string");
        type.put("analyzer", analyzer);
        return type;
    }

    private static Map<String, String> typeTimeWithMillis() {
        HashMap type = Maps.newHashMap();
        type.put("type", "date");
        type.put("format", "yyyy-MM-dd HH:mm:ss.SSS");
        return type;
    }

    private static Map<String, Boolean> enabled() {
        HashMap e = Maps.newHashMap();
        e.put("enabled", true);
        return e;
    }

    private static Map<String, Boolean> enabledAndCompressed() {
        HashMap e = Maps.newHashMap();
        e.put("enabled", true);
        e.put("compress", true);
        return e;
    }
}

