/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.node.Node;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.esplugin.ClusterStateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(Cluster.class);
    private final Client c;
    private final Deflector deflector;
    private final AtomicReference<Map<String, DiscoveryNode>> nodes = new AtomicReference();
    private ScheduledExecutorService scheduler;

    @Inject
    public Cluster(Node node, Deflector deflector, @Named(value="daemonScheduler") ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        this.c = node.client();
        this.deflector = deflector;
        ClusterStateMonitor.setCluster(this);
    }

    public ClusterHealthResponse health() {
        ClusterHealthRequest request = new ClusterHealthRequest(new String[]{this.deflector.getDeflectorWildcard()});
        return (ClusterHealthResponse)this.c.admin().cluster().health(request).actionGet();
    }

    public int getNumberOfNodes() {
        return ((NodeInfo[])((NodesInfoResponse)this.c.admin().cluster().nodesInfo(new NodesInfoRequest().all()).actionGet()).getNodes()).length;
    }

    public List<NodeInfo> getDataNodes() {
        ArrayList dataNodes = Lists.newArrayList();
        for (NodeInfo nodeInfo : this.getAllNodes()) {
            String isData = nodeInfo.getSettings().get("node.data");
            if (isData != null && isData.equals("false")) continue;
            dataNodes.add(nodeInfo);
        }
        return dataNodes;
    }

    public List<NodeInfo> getAllNodes() {
        return Lists.newArrayList((Object[])((NodesInfoResponse)this.c.admin().cluster().nodesInfo(new NodesInfoRequest().all()).actionGet()).getNodes());
    }

    public String nodeIdToName(String nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId);
        return nodeInfo == null ? "UNKNOWN" : nodeInfo.getNode().getName();
    }

    public String nodeIdToHostName(String nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId);
        return nodeInfo == null ? "UNKNOWN" : nodeInfo.getHostname();
    }

    private NodeInfo getNodeInfo(String nodeId) {
        if (nodeId == null || nodeId.isEmpty()) {
            return null;
        }
        try {
            NodesInfoResponse r = (NodesInfoResponse)this.c.admin().cluster().nodesInfo(new NodesInfoRequest(new String[]{nodeId}).all()).actionGet();
            return (NodeInfo)r.getNodesMap().get(nodeId);
        }
        catch (Exception e) {
            LOG.error("Could not read name of ES node.", (Throwable)e);
            return null;
        }
    }

    public boolean isConnectedAndHealthy() {
        Map<String, DiscoveryNode> nodeMap = this.nodes.get();
        if (nodeMap == null || nodeMap.isEmpty()) {
            return false;
        }
        if (!this.deflector.isUp()) {
            return false;
        }
        try {
            return this.health().getStatus() != ClusterHealthStatus.RED;
        }
        catch (ElasticsearchException e) {
            LOG.trace("Couldn't determine Elasticsearch health properly", (Throwable)e);
            return false;
        }
    }

    public void waitForConnectedAndHealthy() throws InterruptedException {
        LOG.debug("Waiting until cluster connection comes back and cluster is healthy, checking once per second.");
        final CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Cluster.this.isConnectedAndHealthy()) {
                        LOG.debug("Cluster is healthy again, unblocking waiting threads.");
                        latch.countDown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        latch.await();
        scheduledFuture.cancel(true);
    }

    public void updateDataNodeList(Map<String, DiscoveryNode> nodes) {
        LOG.debug("{} data nodes in cluster", (Object)nodes.size());
        this.nodes.set(nodes);
    }
}

