/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.esplugin;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.graylog2.indexer.cluster.Cluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateMonitor
extends AbstractLifecycleComponent<ClusterStateMonitor>
implements ClusterStateListener {
    private static final Logger log = LoggerFactory.getLogger(ClusterStateMonitor.class);
    private final ClusterService clusterService;
    private static Cluster cluster;

    @Inject
    public ClusterStateMonitor(Settings settings, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
    }

    public static void setCluster(Cluster cluster) {
        ClusterStateMonitor.cluster = cluster;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().getNodes().masterAndDataNodes().isEmpty()) {
            log.warn("No Elasticsearch data nodes in cluster, cluster is completely offline.");
        }
        if (!event.nodesChanged()) {
            return;
        }
        if (cluster != null) {
            HashMap nodes = Maps.newHashMap();
            for (ObjectObjectCursor cursor : event.state().getNodes().dataNodes()) {
                nodes.put(cursor.key, cursor.value);
            }
            cluster.updateDataNodeList(nodes);
        }
    }

    protected void doStart() throws ElasticsearchException {
        this.clusterService.add((ClusterStateListener)this);
    }

    protected void doStop() throws ElasticsearchException {
        this.clusterService.remove((ClusterStateListener)this);
    }

    protected void doClose() throws ElasticsearchException {
    }
}

