/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;

public class FieldHistogramResult
extends HistogramResult {
    private final DateHistogramFacet result;
    private final Searches.DateHistogramInterval interval;

    public FieldHistogramResult(DateHistogramFacet result, String originalQuery, BytesReference builtQuery, Searches.DateHistogramInterval interval, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.result = result;
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Map<String, Object>> getResults() {
        TreeMap results = Maps.newTreeMap();
        Long minTimestamp = Long.MAX_VALUE;
        Long maxTimestamp = Long.MIN_VALUE;
        for (DateHistogramFacet.Entry e : this.result) {
            HashMap resultMap = Maps.newHashMap();
            resultMap.put("count", e.getCount());
            resultMap.put("min", e.getMin());
            resultMap.put("max", e.getMax());
            resultMap.put("total", e.getTotal());
            resultMap.put("total_count", e.getTotalCount());
            resultMap.put("mean", e.getMean());
            long timestamp = e.getTime() / 1000L;
            if (timestamp < minTimestamp) {
                minTimestamp = timestamp;
            }
            if (timestamp > maxTimestamp) {
                maxTimestamp = timestamp;
            }
            results.put(timestamp, resultMap);
        }
        for (long curTimestamp = minTimestamp.longValue(); curTimestamp < maxTimestamp; curTimestamp += (long)this.interval.getPeriod().toStandardSeconds().getSeconds()) {
            Map entry = (Map)results.get(curTimestamp);
            if (entry != null) continue;
            entry = Maps.newHashMap();
            entry.put("count", 0);
            entry.put("min", 0);
            entry.put("max", 0);
            entry.put("total", 0);
            entry.put("total_count", 0);
            entry.put("mean", 0);
            results.put(curTimestamp, entry);
        }
        return results;
    }
}

