/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import java.util.List;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollResult
extends IndexQueryResult {
    private static final Logger LOG = LoggerFactory.getLogger(ScrollResult.class);
    private final Client client;
    private final List<String> fields;
    private final String queryHash;
    private final long totalHits;
    private String scrollId;
    private int chunkId = 0;

    public ScrollResult(Client client, String originalQuery, BytesReference builtQuery, SearchResponse response, List<String> fields) {
        super(originalQuery, builtQuery, response.getTook());
        this.client = client;
        this.fields = fields;
        this.totalHits = response.getHits().totalHits();
        this.scrollId = response.getScrollId();
        Md5Hash md5Hash = new Md5Hash((Object)this.getOriginalQuery());
        this.queryHash = md5Hash.toHex();
        LOG.debug("[{}] Starting scroll request for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
    }

    public ScrollChunk nextChunk() {
        SearchResponse search = (SearchResponse)this.client.prepareSearchScroll(this.scrollId).setScroll(TimeValue.timeValueMinutes((long)1L)).execute().actionGet();
        SearchHits hits = search.getHits();
        if (hits.getHits().length == 0) {
            LOG.debug("[{}] Reached end of scroll results.", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        LOG.debug("[{}] New scroll id {}", (Object)this.queryHash, (Object)search.getScrollId());
        this.scrollId = search.getScrollId();
        return new ScrollChunk(hits, this.fields, this.chunkId++);
    }

    public String getQueryHash() {
        return this.queryHash;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public void cancel() {
        ClearScrollResponse clearScrollResponse = (ClearScrollResponse)this.client.prepareClearScroll().addScrollId(this.scrollId).execute().actionGet();
        LOG.debug("[{}] clearScroll for query successful: {}", (Object)this.queryHash, (Object)clearScrollResponse.isSucceeded());
    }

    public class ScrollChunk {
        private final List<ResultMessage> resultMessages;
        private List<String> fields;
        private int chunkNumber;

        public ScrollChunk(SearchHits hits, List<String> fields, int chunkId) {
            this.fields = fields;
            this.chunkNumber = chunkId;
            this.resultMessages = ScrollResult.this.buildResults(hits);
        }

        public List<String> getFields() {
            return this.fields;
        }

        public int getChunkNumber() {
            return this.chunkNumber;
        }

        public boolean isFirstChunk() {
            return this.getChunkNumber() == 0;
        }

        public List<ResultMessage> getMessages() {
            return this.resultMessages;
        }
    }
}

