/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation;

import java.text.MessageFormat;
import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountRotationStrategy
implements RotationStrategy {
    private static final Logger log = LoggerFactory.getLogger(MessageCountRotationStrategy.class);
    private final Indices indices;
    private int maxDocsPerIndex;

    @Inject
    public MessageCountRotationStrategy(ElasticsearchConfiguration configuration, Indices indices) {
        this.indices = indices;
        this.maxDocsPerIndex = configuration.getMaxDocsPerIndex();
    }

    public RotationStrategy.Result shouldRotate(String index) {
        try {
            long numberOfMessages = this.indices.numberOfMessages(index);
            return new Result(index, numberOfMessages, this.maxDocsPerIndex, numberOfMessages > (long)this.maxDocsPerIndex);
        }
        catch (IndexNotFoundException e) {
            log.error("Unknown index, cannot perform rotation", (Throwable)e);
            return null;
        }
    }

    private static class Result
    implements RotationStrategy.Result {
        public static final MessageFormat ROTATE_FORMAT = new MessageFormat("Number of messages in <{0}> ({1}) is higher than the limit ({2}). Pointing deflector to new index now!");
        public static final MessageFormat NOT_ROTATE_FORMAT = new MessageFormat("Number of messages in <{0}> ({1}) is lower than the limit ({2}). Not doing anything.");
        private final String index;
        private final long actualCount;
        private final long maxDocs;
        private final boolean shouldRotate;

        public Result(String index, long actualCount, long maxDocs, boolean shouldRotate) {
            this.index = index;
            this.actualCount = actualCount;
            this.maxDocs = maxDocs;
            this.shouldRotate = shouldRotate;
        }

        public String getDescription() {
            MessageFormat format = this.shouldRotate ? ROTATE_FORMAT : NOT_ROTATE_FORMAT;
            return format.format(new Object[]{this.index, this.actualCount, this.maxDocs});
        }

        public boolean shouldRotate() {
            return this.shouldRotate;
        }
    }
}

