/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import java.util.List;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.TimeRange;

public class SearchesConfigBuilder {
    private static final int LIMIT = 150;
    private String query;
    private String filter;
    private List<String> fields;
    private TimeRange range;
    private int limit;
    private int offset;
    private Sorting sorting;

    public static SearchesConfigBuilder newConfig() {
        return new SearchesConfigBuilder();
    }

    public SearchesConfigBuilder setQuery(String query) {
        this.query = query;
        return this;
    }

    public SearchesConfigBuilder setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public SearchesConfigBuilder setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public SearchesConfigBuilder setRange(TimeRange range) {
        this.range = range;
        return this;
    }

    public SearchesConfigBuilder setLimit(int limit) {
        if (limit <= 0) {
            limit = 150;
        }
        this.limit = limit;
        return this;
    }

    public SearchesConfigBuilder setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public SearchesConfigBuilder setSorting(Sorting sorting) {
        this.sorting = sorting;
        return this;
    }

    public SearchesConfig build() {
        return new SearchesConfig(this.query, this.filter, this.fields, this.range, this.limit, this.offset, this.sorting);
    }
}

