/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.initializers;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.initializers.Initializer;
import org.graylog2.plugin.initializers.InitializerConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializers {
    private static final Logger LOG = LoggerFactory.getLogger(Initializers.class);
    private final ServerStatus serverStatus;
    private List<Initializer> initializers;

    @Inject
    public Initializers(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
        this.initializers = Lists.newArrayList();
    }

    public void register(Initializer initializer) {
        if (initializer.masterOnly() && !this.serverStatus.hasCapability(ServerStatus.Capability.MASTER)) {
            LOG.info("Not registering initializer {} because it is marked as master only.", (Object)initializer.getClass().getSimpleName());
            return;
        }
        this.initializers.add(initializer);
    }

    public void initialize() {
        LOG.info("Running [{}] initializers ...", (Object)this.initializers.size());
        for (Initializer i : this.initializers) {
            try {
                i.initialize(new HashMap());
                LOG.info("Initialized initializer <{}>.", (Object)i.getClass().getCanonicalName());
            }
            catch (InitializerConfigurationException e) {
                LOG.error("Could not initialize initializer <" + i.getClass().getCanonicalName() + ">", (Throwable)e);
            }
        }
    }

    public int count() {
        return this.initializers.size();
    }
}

