/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.initializers;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.AbstractIdleService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.database.MongoConnection;
import org.graylog2.metrics.MongoDbMetricsReporter;
import org.graylog2.plugin.ServerStatus;

@Singleton
public class MetricsReporterService
extends AbstractIdleService {
    private final Configuration configuration;
    private final MetricRegistry metricRegistry;
    private final MongoConnection mongoConnection;
    private final ServerStatus serverStatus;
    private MongoDbMetricsReporter metricsReporter = null;

    @Inject
    public MetricsReporterService(Configuration configuration, MetricRegistry metricRegistry, MongoConnection mongoConnection, ServerStatus serverStatus) {
        this.configuration = configuration;
        this.metricRegistry = metricRegistry;
        this.mongoConnection = mongoConnection;
        this.serverStatus = serverStatus;
    }

    protected void startUp() throws Exception {
        if (!this.configuration.isMetricsCollectionEnabled()) {
            return;
        }
        this.metricsReporter = MongoDbMetricsReporter.forRegistry(this.metricRegistry, this.mongoConnection, this.serverStatus).build();
        this.metricsReporter.start(1L, TimeUnit.SECONDS);
    }

    protected void shutDown() throws Exception {
        if (!this.configuration.isMetricsCollectionEnabled()) {
            return;
        }
        if (this.metricsReporter != null) {
            this.metricsReporter.stop();
        }
    }
}

