/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import java.util.Map;
import java.util.regex.Pattern;
import org.graylog2.plugin.inputs.Converter;

public class IPAnonymizerConverter
extends Converter {
    public static final String REPLACEMENT = "$1.$2.$3.xxx";
    public static final Pattern p = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");

    public IPAnonymizerConverter(Map<String, Object> config) {
        super(Converter.Type.IP_ANONYMIZER, config);
    }

    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return p.matcher(value).replaceAll(REPLACEMENT);
    }

    public boolean buildsMultipleFields() {
        return false;
    }
}

