/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbMetricsReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbMetricsReporter.class);
    private final Clock clock;
    private final String nodeId;
    private final MongoConnection mongoConnection;

    private MongoDbMetricsReporter(MetricRegistry registry, MongoConnection mongoConnection, ServerStatus serverStatus, Clock clock, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "mongodb-reporter", filter, rateUnit, durationUnit);
        this.mongoConnection = mongoConnection;
        this.nodeId = serverStatus.getNodeId().toString();
        this.clock = clock;
    }

    public static Builder forRegistry(MetricRegistry registry, MongoConnection mongoConnection, ServerStatus serverStatus) {
        return new Builder(registry, mongoConnection, serverStatus);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Date timestamp = new Date(this.clock.getTime());
        ArrayList docs = Lists.newArrayListWithExpectedSize((int)(gauges.size() + counters.size() + histograms.size() + meters.size() + timers.size()));
        this.collectGaugeReports(docs, gauges, timestamp);
        this.collectCounterReports(docs, counters, timestamp);
        this.collectHistogramReports(docs, histograms, timestamp);
        this.collectMeterReports(docs, meters, timestamp);
        this.collectTimerReports(docs, timers, timestamp);
        try {
            DBCollection collection = this.mongoConnection.getDatabase().getCollection("graylog2_metrics");
            BasicDBObject indexField = new BasicDBObject("timestamp", (Object)1);
            BasicDBObject indexOptions = new BasicDBObject("expireAfterSeconds", (Object)300);
            collection.createIndex((DBObject)indexField, (DBObject)indexOptions);
            collection.insert((List)docs, WriteConcern.UNACKNOWLEDGED);
        }
        catch (Exception e) {
            LOG.warn("Unable to write graylog2 metrics to mongodb. Ignoring this error.", (Throwable)e);
        }
    }

    private void collectGaugeReports(List<DBObject> docs, SortedMap<String, Gauge> gauges, Date timestamp) {
        if (gauges.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            BasicDBObject report = this.getBasicDBObject(timestamp, entry.getKey(), "gauge");
            report.put("value", entry.getValue().getValue());
            docs.add((DBObject)report);
        }
    }

    private void collectCounterReports(List<DBObject> docs, SortedMap<String, Counter> counters, Date timestamp) {
        if (counters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            BasicDBObject report = this.getBasicDBObject(timestamp, entry.getKey(), "counter");
            report.put("count", (Object)entry.getValue().getCount());
            docs.add((DBObject)report);
        }
    }

    private void collectHistogramReports(List<DBObject> docs, SortedMap<String, Histogram> histograms, Date timestamp) {
        if (histograms.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            BasicDBObject report = this.getBasicDBObject(timestamp, entry.getKey(), "histogram");
            Histogram histogram = entry.getValue();
            Snapshot s = histogram.getSnapshot();
            report.put("count", (Object)s.size());
            report.put("75th_percentile", (Object)s.get75thPercentile());
            report.put("95th_percentile", (Object)s.get95thPercentile());
            report.put("98th_percentile", (Object)s.get98thPercentile());
            report.put("99th_percentile", (Object)s.get99thPercentile());
            report.put("999th_percentile", (Object)s.get999thPercentile());
            report.put("max", (Object)s.getMax());
            report.put("min", (Object)s.getMin());
            report.put("mean", (Object)s.getMean());
            report.put("median", (Object)s.getMedian());
            report.put("std_dev", (Object)s.getStdDev());
            docs.add((DBObject)report);
        }
    }

    private void collectMeterReports(List<DBObject> docs, SortedMap<String, Meter> meters, Date timestamp) {
        if (meters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            BasicDBObject report = this.getBasicDBObject(timestamp, entry.getKey(), "meter");
            Meter v = entry.getValue();
            report.put("count", (Object)v.getCount());
            report.put("1-minute-rate", (Object)v.getOneMinuteRate());
            report.put("5-minute-rate", (Object)v.getFiveMinuteRate());
            report.put("15-minute-rate", (Object)v.getFifteenMinuteRate());
            report.put("mean-rate", (Object)v.getMeanRate());
            docs.add((DBObject)report);
        }
    }

    private void collectTimerReports(List<DBObject> docs, SortedMap<String, Timer> timers, Date timestamp) {
        if (timers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            BasicDBObject report = this.getBasicDBObject(timestamp, entry.getKey(), "timer");
            Timer v = entry.getValue();
            Snapshot s = v.getSnapshot();
            report.put("count", (Object)v.getCount());
            report.put("rate-unit", (Object)this.getRateUnit());
            report.put("1-minute-rate", (Object)this.convertRate(v.getOneMinuteRate()));
            report.put("5-minute-rate", (Object)this.convertRate(v.getFiveMinuteRate()));
            report.put("15-minute-rate", (Object)this.convertRate(v.getFifteenMinuteRate()));
            report.put("mean-rate", (Object)this.convertRate(v.getMeanRate()));
            report.put("duration-unit", (Object)this.getDurationUnit());
            report.put("75-percentile", (Object)this.convertDuration(s.get75thPercentile()));
            report.put("95-percentile", (Object)this.convertDuration(s.get95thPercentile()));
            report.put("98-percentile", (Object)this.convertDuration(s.get98thPercentile()));
            report.put("99-percentile", (Object)this.convertDuration(s.get99thPercentile()));
            report.put("999-percentile", (Object)this.convertDuration(s.get999thPercentile()));
            report.put("max", (Object)this.convertDuration(s.getMax()));
            report.put("min", (Object)this.convertDuration(s.getMin()));
            report.put("mean", (Object)this.convertDuration(s.getMean()));
            report.put("median", (Object)this.convertDuration(s.getMedian()));
            report.put("stddev", (Object)this.convertDuration(s.getStdDev()));
            docs.add((DBObject)report);
        }
    }

    private BasicDBObject getBasicDBObject(Date timestamp, String metricName, String metricType) {
        BasicDBObject report = new BasicDBObject();
        report.put("_id", (Object)new ObjectId());
        report.put("type", (Object)metricType);
        report.put("timestamp", (Object)timestamp);
        report.put("name", (Object)metricName);
        report.put("node", (Object)this.nodeId);
        return report;
    }

    public static class Builder {
        private final MetricRegistry registry;
        private final MongoConnection mongoConnection;
        private final ServerStatus serverStatus;
        private final Clock clock;
        private final TimeUnit rateUnit;
        private final TimeUnit durationUnit;
        private final MetricFilter filter;

        @Inject
        private Builder(MetricRegistry registry, MongoConnection mongoConnection, ServerStatus serverStatus) {
            this.registry = registry;
            this.mongoConnection = mongoConnection;
            this.serverStatus = serverStatus;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public MongoDbMetricsReporter build() {
            return new MongoDbMetricsReporter(this.registry, this.mongoConnection, this.serverStatus, this.clock, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

