/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.github.joschi.jadconfig.util.Duration;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.inject.Inject;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.graylog2.Configuration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionWarningThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollectionWarningThread.class);
    private final List<GarbageCollectorMXBean> garbageCollectors;
    private final Duration gcWarningThreshold;
    private final NodeId nodeId;
    private final NotificationService notificationService;

    @Inject
    public GarbageCollectionWarningThread(Configuration configuration, NodeId nodeId, NotificationService notificationService) {
        this(configuration.getGcWarningThreshold(), nodeId, notificationService);
    }

    GarbageCollectionWarningThread(Duration gcWarningThreshold, NodeId nodeId, NotificationService notificationService) {
        this(ManagementFactory.getGarbageCollectorMXBeans(), gcWarningThreshold, nodeId, notificationService);
    }

    GarbageCollectionWarningThread(List<GarbageCollectorMXBean> garbageCollectors, Duration gcWarningThreshold, NodeId nodeId, NotificationService notificationService) {
        this.garbageCollectors = garbageCollectors;
        this.gcWarningThreshold = gcWarningThreshold;
        this.nodeId = nodeId;
        this.notificationService = notificationService;
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        block7: for (final GarbageCollectorMXBean gc : this.garbageCollectors) {
            switch (gc.getName()) {
                case "ParNew": 
                case "ConcurrentMarkSweep": {
                    LOG.debug("Skipping GC warning listener for concurrent collector {}.", (Object)gc.getName());
                    continue block7;
                }
            }
            LOG.debug("Installing GC warning listener for collector {}, total runtime threshold is {}.", (Object)gc.getName(), (Object)this.gcWarningThreshold);
            NotificationEmitter emitter = (NotificationEmitter)((Object)gc);
            NotificationListener listener = new NotificationListener(){

                @Override
                public void handleNotification(javax.management.Notification notification, Object handback) {
                    GcInfo gcInfo;
                    Duration duration;
                    if ("com.sun.management.gc.notification".equals(notification.getType()) && (duration = Duration.milliseconds((long)(gcInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData()).getGcInfo()).getDuration())).compareTo(GarbageCollectionWarningThread.this.gcWarningThreshold) > 0) {
                        LOG.warn("Last GC run with {} took longer than {} (last duration={})", new Object[]{gc.getName(), GarbageCollectionWarningThread.this.gcWarningThreshold, duration});
                        Notification systemNotification = GarbageCollectionWarningThread.this.notificationService.buildNow().addNode(GarbageCollectionWarningThread.this.nodeId.toString()).addTimestamp(Tools.iso8601()).addSeverity(Notification.Severity.URGENT).addType(Notification.Type.GC_TOO_LONG).addDetail("gc_name", gc.getName()).addDetail("gc_duration_ms", duration.toMilliseconds()).addDetail("gc_threshold_ms", GarbageCollectionWarningThread.this.gcWarningThreshold.toMilliseconds()).addDetail("gc_collection_count", gc.getCollectionCount()).addDetail("gc_collection_time", gc.getCollectionTime());
                        if (!GarbageCollectionWarningThread.this.notificationService.publishIfFirst(systemNotification)) {
                            LOG.debug("Couldn't publish notification: {}", (Object)notification);
                        }
                    }
                }
            };
            emitter.addNotificationListener(listener, null, null);
        }
    }
}

