/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.indexer.retention.RetentionStrategyFactory;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRetentionThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRetentionThread.class);
    private final ElasticsearchConfiguration configuration;
    private final RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory;
    private final Deflector deflector;
    private final Cluster cluster;
    private final ActivityWriter activityWriter;
    private final SystemJobManager systemJobManager;
    private final Indices indices;

    @Inject
    public IndexRetentionThread(ElasticsearchConfiguration configuration, RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory, Deflector deflector, Indices indices, Cluster cluster, ActivityWriter activityWriter, SystemJobManager systemJobManager) {
        this.configuration = configuration;
        this.rebuildIndexRangesJobFactory = rebuildIndexRangesJobFactory;
        this.deflector = deflector;
        this.indices = indices;
        this.cluster = cluster;
        this.activityWriter = activityWriter;
        this.systemJobManager = systemJobManager;
    }

    public void doRun() {
        int maxIndices;
        if (!this.cluster.isConnectedAndHealthy()) {
            LOG.info("Elasticsearch cluster not available, skipping index retention checks.");
            return;
        }
        Map<String, IndexStats> deflectorIndices = this.deflector.getAllDeflectorIndices();
        int indexCount = deflectorIndices.size();
        if (indexCount <= (maxIndices = this.configuration.getMaxNumberOfIndices())) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, (Object)maxIndices);
            return;
        }
        int removeCount = indexCount - maxIndices;
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxIndices + "). " + "Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        try {
            this.runRetention(RetentionStrategyFactory.fromString(this.configuration.getRetentionStrategy(), this.indices), deflectorIndices, removeCount);
        }
        catch (RetentionStrategyFactory.NoSuchStrategyException e) {
            LOG.error("Could not run index retention. No such strategy.", (Throwable)e);
        }
        catch (NoTargetIndexException e) {
            LOG.error("Could not run index retention. No target index.", (Throwable)e);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void runRetention(RetentionStrategy strategy, Map<String, IndexStats> deflectorIndices, int removeCount) throws NoTargetIndexException {
        for (String indexName : IndexHelper.getOldestIndices(deflectorIndices.keySet(), removeCount)) {
            if (this.deflector.getCurrentActualTargetIndex().equals(indexName)) {
                LOG.info("Not running retention against current deflector target <{}>.", (Object)indexName);
                continue;
            }
            if (this.indices.isReopened(indexName)) {
                LOG.info("Not running retention against reopened index <{}>.", (Object)indexName);
                continue;
            }
            String msg = "Running retention strategy [" + strategy.getClass().getCanonicalName() + "] " + "for index <" + indexName + ">";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            strategy.runStrategy(indexName);
        }
        try {
            this.systemJobManager.submit(this.rebuildIndexRangesJobFactory.create(this.deflector));
        }
        catch (SystemJobConcurrencyException e) {
            String msg = "Could not re-calculate index ranges after running retention: Maximum concurrency of job is reached.";
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            LOG.error(msg);
        }
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return this.configuration.performRetention();
    }

    public boolean isDaemon() {
        return false;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(5L);
    }
}

