/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePingThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(NodePingThread.class);
    private final NodeService nodeService;
    private final NotificationService notificationService;
    private final ActivityWriter activityWriter;
    private final Configuration configuration;
    private final ServerStatus serverStatus;

    @Inject
    public NodePingThread(NodeService nodeService, NotificationService notificationService, ActivityWriter activityWriter, Configuration configuration, ServerStatus serverStatus) {
        this.nodeService = nodeService;
        this.notificationService = notificationService;
        this.activityWriter = activityWriter;
        this.configuration = configuration;
        this.serverStatus = serverStatus;
    }

    public void doRun() {
        boolean isMaster = this.serverStatus.hasCapability(ServerStatus.Capability.MASTER);
        try {
            Node node = this.nodeService.byNodeId(this.serverStatus.getNodeId());
            this.nodeService.markAsAlive(node, isMaster, this.configuration.getRestTransportUri());
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Did not find meta info of this node. Re-registering.");
            this.nodeService.registerServer(this.serverStatus.getNodeId().toString(), isMaster, this.configuration.getRestTransportUri());
        }
        try {
            Notification notification;
            this.nodeService.dropOutdated();
            if (this.nodeService.isAnyMasterPresent()) {
                notification = this.notificationService.build().addType(Notification.Type.NO_MASTER);
                boolean removedNotification = this.notificationService.fixed(notification);
                if (removedNotification) {
                    this.activityWriter.write(new Activity("Notification condition [" + (Object)((Object)Notification.Type.NO_MASTER) + "] " + "has been fixed.", NodePingThread.class));
                }
            } else {
                notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.NO_MASTER).addSeverity(Notification.Severity.URGENT);
                this.notificationService.publishIfFirst(notification);
            }
        }
        catch (Exception e) {
            LOG.warn("Caught exception during node ping.", (Throwable)e);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 1;
    }
}

